/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.geojson;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import eu.trentorise.opendata.traceprov.geojson.AGeometry;
import eu.trentorise.opendata.traceprov.geojson.Point;
import eu.trentorise.opendata.traceprov.validation.Preconditions;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=Point.class)
@JsonDeserialize(as=Point.class)
@Value.Immutable(singleton=false)
abstract class APoint
extends AGeometry {
    private static final long serialVersionUID = 1L;

    APoint() {
    }

    @Override
    public abstract List<Double> getCoordinates();

    @Value.Check
    protected void check() {
        Preconditions.checkPosition(this.getCoordinates(), "Invalid Point!");
    }

    public static Point of(double lat, double lon) {
        return Point.builder().addCoordinates(lat, lon).build();
    }

    public static Point of() {
        return Point.builder().addCoordinates(0.0, 0.0).build();
    }
}

