/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.geojson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import eu.trentorise.opendata.traceprov.geojson.ACrs;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class Crs
extends ACrs {
    private final String type;
    private final Map<String, ?> properties;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final Crs INSTANCE = Crs.validate(new Crs());
    private static final long serialVersionUID = 1L;

    private Crs() {
        this.type = this.initShim.getType();
        this.properties = this.initShim.getProperties();
        this.initShim = null;
    }

    private Crs(String type, Map<String, ?> properties) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.properties = (Map)Preconditions.checkNotNull(properties);
        this.initShim = null;
    }

    private Crs(Crs original, String type, Map<String, ?> properties) {
        this.type = type;
        this.properties = properties;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.initShim != null ? this.initShim.getType() : this.type;
    }

    @Override
    @JsonProperty
    public Map<String, ?> getProperties() {
        return this.initShim != null ? this.initShim.getProperties() : this.properties;
    }

    public final Crs withType(String value) {
        if (this.type == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return Crs.validate(new Crs(this, newValue, this.properties));
    }

    public final Crs withProperties(Map<String, ?> value) {
        if (this.properties == value) {
            return this;
        }
        Map newValue = (Map)Preconditions.checkNotNull(value);
        return Crs.validate(new Crs(this, this.type, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Crs && this.equalTo((Crs)another);
    }

    private boolean equalTo(Crs another) {
        return this.type.equals(another.type) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Crs").add("type", (Object)this.type).add("properties", this.properties).toString();
    }

    @Deprecated
    @JsonCreator
    static Crs fromJson(Json json) {
        Crs instance = Crs.of(json.type, json.properties);
        return instance;
    }

    public static Crs of() {
        return INSTANCE;
    }

    public static Crs of(String type, Map<String, ?> properties) {
        return Crs.validate(new Crs(type, properties));
    }

    private static Crs validate(Crs instance) {
        instance.check();
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static Crs copyOf(Crs instance) {
        if (instance instanceof Crs) {
            return instance;
        }
        return Crs.of(instance.getType(), instance.getProperties());
    }

    private Object readResolve() throws ObjectStreamException {
        return Crs.validate(this);
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        String type;
        @JsonProperty
        @Nullable
        Map<String, ?> properties;

        Json() {
        }
    }

    private final class InitShim {
        private String type;
        private byte typeStage;
        private Map<String, ?> properties;
        private byte propertiesStage;

        private InitShim() {
        }

        String getType() {
            if (this.typeStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeStage == 0) {
                this.typeStage = (byte)-1;
                this.type = (String)Preconditions.checkNotNull((Object)Crs.super.getType());
                this.typeStage = 1;
            }
            return this.type;
        }

        String setType(String value) {
            this.type = value;
            this.typeStage = 1;
            return value;
        }

        Map<String, ?> getProperties() {
            if (this.propertiesStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertiesStage == 0) {
                this.propertiesStage = (byte)-1;
                this.properties = (Map)Preconditions.checkNotNull((Object)Crs.super.getProperties());
                this.propertiesStage = 1;
            }
            return this.properties;
        }

        Map<String, ?> setProperties(Map<String, ?> value) {
            this.properties = value;
            this.propertiesStage = 1;
            return value;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.typeStage == -1) {
                attributes.add("type");
            }
            if (this.propertiesStage == -1) {
                attributes.add("properties");
            }
            return "Cannot build Crs, attribute initializers form cycle" + attributes;
        }
    }
}

