/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.geojson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import eu.trentorise.opendata.traceprov.geojson.AFeature;
import eu.trentorise.opendata.traceprov.geojson.AGeometry;
import eu.trentorise.opendata.traceprov.geojson.Crs;
import eu.trentorise.opendata.traceprov.geojson.GeoJson;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class Feature
extends AFeature {
    private final String id;
    @Nullable
    private final Object properties;
    @Nullable
    private final AGeometry geometry;
    private final String type;
    private final ImmutableList<Double> bbox;
    @Nullable
    private final Crs crs;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile InitShim initShim = new InitShim();
    private static final Feature INSTANCE = Feature.validate(new Feature());
    private static final long serialVersionUID = 1L;

    private Feature() {
        this.geometry = null;
        this.bbox = ImmutableList.of();
        this.crs = null;
        this.id = this.initShim.getId();
        this.properties = this.initShim.getProperties();
        this.type = this.initShim.getType();
        this.initShim = null;
    }

    private Feature(Builder builder) {
        this.geometry = builder.geometry;
        this.bbox = builder.bboxBuilder.build();
        this.crs = builder.crs;
        if (builder.id != null) {
            this.initShim.setId(builder.id);
        }
        if (builder.properties != null) {
            this.initShim.setProperties(builder.properties);
        }
        this.id = this.initShim.getId();
        this.properties = this.initShim.getProperties();
        this.type = (String)Preconditions.checkNotNull((Object)super.getType());
        this.initShim = null;
    }

    private Feature(String id, @Nullable Object properties, @Nullable AGeometry geometry, ImmutableList<Double> bbox, @Nullable Crs crs) {
        this.id = id;
        this.properties = properties;
        this.geometry = geometry;
        this.bbox = bbox;
        this.crs = crs;
        this.type = (String)Preconditions.checkNotNull((Object)super.getType());
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="@id")
    public String getId() {
        return this.initShim != null ? this.initShim.getId() : this.id;
    }

    @Override
    @JsonProperty
    @Nullable
    public Object getProperties() {
        return this.initShim != null ? this.initShim.getProperties() : this.properties;
    }

    @Override
    @JsonProperty
    @Nullable
    public AGeometry getGeometry() {
        return this.geometry;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.initShim != null ? this.initShim.getType() : this.type;
    }

    @JsonProperty
    public ImmutableList<Double> getBbox() {
        return this.bbox;
    }

    @Override
    @JsonProperty
    @Nullable
    public Crs getCrs() {
        return this.crs;
    }

    public final Feature withId(String value) {
        if (this.id == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return Feature.validate(new Feature(newValue, this.properties, this.geometry, this.bbox, this.crs));
    }

    public final Feature withProperties(@Nullable Object value) {
        if (this.properties == value) {
            return this;
        }
        Object newValue = value;
        return Feature.validate(new Feature(this.id, newValue, this.geometry, this.bbox, this.crs));
    }

    public final Feature withGeometry(@Nullable AGeometry value) {
        if (this.geometry == value) {
            return this;
        }
        AGeometry newValue = value;
        return Feature.validate(new Feature(this.id, this.properties, newValue, this.bbox, this.crs));
    }

    public final Feature withBbox(double ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Doubles.asList((double[])elements));
        return Feature.validate(new Feature(this.id, this.properties, this.geometry, (ImmutableList<Double>)newValue, this.crs));
    }

    public final Feature withBbox(Iterable<Double> elements) {
        if (this.bbox == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return Feature.validate(new Feature(this.id, this.properties, this.geometry, (ImmutableList<Double>)newValue, this.crs));
    }

    public final Feature withCrs(@Nullable Crs value) {
        if (this.crs == value) {
            return this;
        }
        Crs newValue = value;
        return Feature.validate(new Feature(this.id, this.properties, this.geometry, this.bbox, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Feature && this.equalTo((Feature)another);
    }

    private boolean equalTo(Feature another) {
        return this.id.equals(another.id) && Objects.equal((Object)this.properties, (Object)another.properties) && Objects.equal((Object)this.geometry, (Object)another.geometry) && this.type.equals(another.type) && this.bbox.equals(another.bbox) && Objects.equal((Object)this.crs, (Object)another.crs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.properties});
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.geometry});
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.bbox.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.crs});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Feature").add("id", (Object)this.id).add("properties", this.properties).add("geometry", (Object)this.geometry).add("type", (Object)this.type).add("bbox", this.bbox).add("crs", (Object)this.crs).toString();
    }

    @Deprecated
    @JsonCreator
    static Feature fromJson(Json json) {
        Builder builder = Feature.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.properties != null) {
            builder.setProperties(json.properties);
        }
        if (json.geometry != null) {
            builder.setGeometry(json.geometry);
        }
        if (json.bbox != null) {
            builder.addAllBbox(json.bbox);
        }
        if (json.crs != null) {
            builder.setCrs(json.crs);
        }
        return builder.build();
    }

    public static Feature of() {
        return INSTANCE;
    }

    private static Feature validate(Feature instance) {
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static Feature copyOf(Feature instance) {
        if (instance instanceof Feature) {
            return instance;
        }
        return Feature.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Feature.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private Object properties;
        @Nullable
        private AGeometry geometry;
        private ImmutableList.Builder<Double> bboxBuilder = ImmutableList.builder();
        @Nullable
        private Crs crs;

        private Builder() {
        }

        public final Builder from(Feature instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GeoJson instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GeoJson instance;
            if (object instanceof AFeature) {
                Object propertiesValue;
                instance = (AFeature)object;
                this.setId(((AFeature)instance).getId());
                AGeometry geometryValue = ((AFeature)instance).getGeometry();
                if (geometryValue != null) {
                    this.setGeometry(geometryValue);
                }
                if ((propertiesValue = ((AFeature)instance).getProperties()) != null) {
                    this.setProperties(propertiesValue);
                }
            }
            if (object instanceof GeoJson) {
                instance = (GeoJson)object;
                Crs crsValue = instance.getCrs();
                if (crsValue != null) {
                    this.setCrs(crsValue);
                }
                this.addAllBbox(instance.getBbox());
            }
        }

        public final Builder setId(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id);
            return this;
        }

        public final Builder setProperties(@Nullable Object properties) {
            this.properties = properties;
            return this;
        }

        public final Builder setGeometry(@Nullable AGeometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final Builder addBbox(double element) {
            this.bboxBuilder.add((Object)element);
            return this;
        }

        public final Builder addBbox(double ... elements) {
            this.bboxBuilder.addAll((Iterable)Doubles.asList((double[])elements));
            return this;
        }

        public final Builder setBbox(Iterable<Double> elements) {
            this.bboxBuilder = ImmutableList.builder();
            return this.addAllBbox(elements);
        }

        public final Builder addAllBbox(Iterable<Double> elements) {
            this.bboxBuilder.addAll(elements);
            return this;
        }

        public final Builder setCrs(@Nullable Crs crs) {
            this.crs = crs;
            return this;
        }

        public Feature build() throws IllegalStateException {
            return Feature.validate(new Feature(this));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty(value="@id")
        @Nullable
        String id;
        @JsonProperty
        @Nullable
        Object properties;
        @JsonProperty
        @Nullable
        AGeometry geometry;
        @JsonProperty
        @Nullable
        String type;
        @JsonProperty
        @Nullable
        List<Double> bbox;
        @JsonProperty
        @Nullable
        Crs crs;

        Json() {
        }
    }

    private final class InitShim {
        private String id;
        private byte idStage;
        private Object properties;
        private byte propertiesStage;
        private String type;
        private byte typeStage;

        private InitShim() {
        }

        String getId() {
            if (this.idStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idStage == 0) {
                this.idStage = (byte)-1;
                this.id = (String)Preconditions.checkNotNull((Object)Feature.super.getId());
                this.idStage = 1;
            }
            return this.id;
        }

        String setId(String value) {
            this.id = value;
            this.idStage = 1;
            return value;
        }

        Object getProperties() {
            if (this.propertiesStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.propertiesStage == 0) {
                this.propertiesStage = (byte)-1;
                this.properties = Feature.super.getProperties();
                this.propertiesStage = 1;
            }
            return this.properties;
        }

        Object setProperties(Object value) {
            this.properties = value;
            this.propertiesStage = 1;
            return value;
        }

        String getType() {
            if (this.typeStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeStage == 0) {
                this.typeStage = (byte)-1;
                this.type = (String)Preconditions.checkNotNull((Object)Feature.super.getType());
                this.typeStage = 1;
            }
            return this.type;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.idStage == -1) {
                attributes.add("id");
            }
            if (this.propertiesStage == -1) {
                attributes.add("properties");
            }
            if (this.typeStage == -1) {
                attributes.add("type");
            }
            return "Cannot build Feature, attribute initializers form cycle" + attributes;
        }
    }
}

