/*
 * Decompiled with CFR 0.152.
 */
package eu.trentorise.opendata.traceprov.geojson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import eu.trentorise.opendata.traceprov.geojson.AGeometry;
import eu.trentorise.opendata.traceprov.geojson.APolygon;
import eu.trentorise.opendata.traceprov.geojson.Crs;
import eu.trentorise.opendata.traceprov.geojson.GeoJson;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class Polygon
extends APolygon {
    private final ImmutableList<ImmutableList<ImmutableList<Double>>> coordinates;
    private final String type;
    private final ImmutableList<Double> bbox;
    @Nullable
    private final Crs crs;
    private static final Polygon INSTANCE = Polygon.validate(new Polygon());
    private static final long serialVersionUID = 1L;

    private Polygon() {
        this.coordinates = ImmutableList.of();
        this.bbox = ImmutableList.of();
        this.crs = null;
        this.type = (String)Preconditions.checkNotNull((Object)super.getType());
    }

    private Polygon(ImmutableList<ImmutableList<ImmutableList<Double>>> coordinates, ImmutableList<Double> bbox, @Nullable Crs crs) {
        this.coordinates = coordinates;
        this.bbox = bbox;
        this.crs = crs;
        this.type = (String)Preconditions.checkNotNull((Object)super.getType());
    }

    @Override
    @JsonProperty
    public ImmutableList<ImmutableList<ImmutableList<Double>>> getCoordinates() {
        return this.coordinates;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public ImmutableList<Double> getBbox() {
        return this.bbox;
    }

    @Override
    @JsonProperty
    @Nullable
    public Crs getCrs() {
        return this.crs;
    }

    @SafeVarargs
    public final Polygon withCoordinates(ImmutableList<ImmutableList<Double>> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return Polygon.validate(new Polygon((ImmutableList<ImmutableList<ImmutableList<Double>>>)newValue, this.bbox, this.crs));
    }

    public final Polygon withCoordinates(Iterable<? extends ImmutableList<ImmutableList<Double>>> elements) {
        if (this.coordinates == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return Polygon.validate(new Polygon((ImmutableList<ImmutableList<ImmutableList<Double>>>)newValue, this.bbox, this.crs));
    }

    public final Polygon withBbox(double ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Collection)Doubles.asList((double[])elements));
        return Polygon.validate(new Polygon(this.coordinates, (ImmutableList<Double>)newValue, this.crs));
    }

    public final Polygon withBbox(Iterable<Double> elements) {
        if (this.bbox == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return Polygon.validate(new Polygon(this.coordinates, (ImmutableList<Double>)newValue, this.crs));
    }

    public final Polygon withCrs(@Nullable Crs value) {
        if (this.crs == value) {
            return this;
        }
        Crs newValue = value;
        return Polygon.validate(new Polygon(this.coordinates, this.bbox, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Polygon && this.equalTo((Polygon)another);
    }

    private boolean equalTo(Polygon another) {
        return this.coordinates.equals(another.coordinates) && this.type.equals(another.type) && this.bbox.equals(another.bbox) && Objects.equal((Object)this.crs, (Object)another.crs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.coordinates.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.bbox.hashCode();
        h = h * 17 + Objects.hashCode((Object[])new Object[]{this.crs});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Polygon").add("coordinates", this.coordinates).add("type", (Object)this.type).add("bbox", this.bbox).add("crs", (Object)this.crs).toString();
    }

    @Deprecated
    @JsonCreator
    static Polygon fromJson(Json json) {
        Builder builder = Polygon.builder();
        if (json.coordinates != null) {
            builder.addAllCoordinates((Iterable<? extends ImmutableList<ImmutableList<Double>>>)json.coordinates);
        }
        if (json.bbox != null) {
            builder.addAllBbox(json.bbox);
        }
        if (json.crs != null) {
            builder.setCrs(json.crs);
        }
        return builder.build();
    }

    public static Polygon of() {
        return INSTANCE;
    }

    private static Polygon validate(Polygon instance) {
        instance.check();
        return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
    }

    public static Polygon copyOf(Polygon instance) {
        if (instance instanceof Polygon) {
            return instance;
        }
        return Polygon.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return Polygon.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<ImmutableList<ImmutableList<Double>>> coordinatesBuilder = ImmutableList.builder();
        private ImmutableList.Builder<Double> bboxBuilder = ImmutableList.builder();
        @Nullable
        private Crs crs;

        private Builder() {
        }

        public final Builder from(Polygon instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GeoJson instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AGeometry instance) {
            Preconditions.checkNotNull((Object)instance);
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GeoJson instance;
            long bits = 0L;
            if (object instanceof APolygon) {
                instance = (APolygon)object;
                if ((bits & 1L) == 0L) {
                    this.addAllCoordinates((Iterable<? extends ImmutableList<ImmutableList<Double>>>)((APolygon)instance).getCoordinates());
                    bits |= 1L;
                }
            }
            if (object instanceof GeoJson) {
                instance = (GeoJson)object;
                Crs crsValue = instance.getCrs();
                if (crsValue != null) {
                    this.setCrs(crsValue);
                }
                this.addAllBbox(instance.getBbox());
            }
            if (object instanceof AGeometry) {
                instance = (AGeometry)object;
                if ((bits & 1L) == 0L) {
                    this.addAllCoordinates(((AGeometry)instance).getCoordinates());
                    bits |= 1L;
                }
            }
        }

        public final Builder addCoordinates(ImmutableList<ImmutableList<Double>> element) {
            this.coordinatesBuilder.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder addCoordinates(ImmutableList<ImmutableList<Double>> ... elements) {
            this.coordinatesBuilder.add((Object[])elements);
            return this;
        }

        public final Builder setCoordinates(Iterable<? extends ImmutableList<ImmutableList<Double>>> elements) {
            this.coordinatesBuilder = ImmutableList.builder();
            return this.addAllCoordinates(elements);
        }

        public final Builder addAllCoordinates(Iterable<? extends ImmutableList<ImmutableList<Double>>> elements) {
            this.coordinatesBuilder.addAll(elements);
            return this;
        }

        public final Builder addBbox(double element) {
            this.bboxBuilder.add((Object)element);
            return this;
        }

        public final Builder addBbox(double ... elements) {
            this.bboxBuilder.addAll((Iterable)Doubles.asList((double[])elements));
            return this;
        }

        public final Builder setBbox(Iterable<Double> elements) {
            this.bboxBuilder = ImmutableList.builder();
            return this.addAllBbox(elements);
        }

        public final Builder addAllBbox(Iterable<Double> elements) {
            this.bboxBuilder.addAll(elements);
            return this;
        }

        public final Builder setCrs(@Nullable Crs crs) {
            this.crs = crs;
            return this;
        }

        public Polygon build() throws IllegalStateException {
            return Polygon.validate(new Polygon(this.coordinatesBuilder.build(), this.bboxBuilder.build(), this.crs));
        }
    }

    @Deprecated
    static final class Json {
        @JsonProperty
        @Nullable
        ImmutableList<ImmutableList<ImmutableList<Double>>> coordinates;
        @JsonProperty
        @Nullable
        String type;
        @JsonProperty
        @Nullable
        List<Double> bbox;
        @JsonProperty
        @Nullable
        Crs crs;

        Json() {
        }
    }
}

