/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventPortlet;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;

public abstract class GenericPortlet
implements Portlet,
PortletConfig,
EventPortlet,
ResourceServingPortlet {
    private transient PortletConfig config;

    public void init(PortletConfig config) throws PortletException {
        this.config = config;
        this.init();
    }

    public void init() throws PortletException {
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        throw new PortletException("processAction method not implemented");
    }

    public void render(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (request.getAttribute("javax.portlet.render_part") != null) {
            if (request.getAttribute("javax.portlet.render_part").equals("RENDER_HEADERS")) {
                this.doHeaders(request, response);
                response.setTitle(this.getTitle(request));
            } else if (request.getAttribute("javax.portlet.render_part").equals("RENDER_MARKUP")) {
                this.doDispatch(request, response);
            }
        } else {
            this.doHeaders(request, response);
            response.setTitle(this.getTitle(request));
            this.doDispatch(request, response);
        }
    }

    protected String getTitle(RenderRequest request) {
        if (this.config == null) {
            throw new IllegalStateException("Config is null, please ensure that your init(config) method calls super.init(config)");
        }
        return this.config.getResourceBundle(request.getLocale()).getString("javax.portlet.title");
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WindowState state = request.getWindowState();
        if (!state.equals(WindowState.MINIMIZED)) {
            PortletMode mode = request.getPortletMode();
            if (mode.equals(PortletMode.VIEW)) {
                this.doView(request, response);
            } else if (mode.equals(PortletMode.EDIT)) {
                this.doEdit(request, response);
            } else if (mode.equals(PortletMode.HELP)) {
                this.doHelp(request, response);
            } else {
                throw new PortletException("unknown portlet mode: " + mode);
            }
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doView method not implemented");
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doEdit method not implemented");
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        throw new PortletException("doHelp method not implemented");
    }

    public PortletConfig getPortletConfig() {
        return this.config;
    }

    public void destroy() {
    }

    public String getPortletName() {
        return this.config.getPortletName();
    }

    public PortletContext getPortletContext() {
        return this.config.getPortletContext();
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return this.config.getResourceBundle(locale);
    }

    public String getInitParameter(String name) {
        return this.config.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.config.getInitParameterNames();
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortletRequestDispatcher rd = this.getPortletConfig().getPortletContext().getRequestDispatcher(request.getResourceID());
        rd.forward(request, response);
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        Method[] methods = this.getClass().getMethods();
        QName eventName = request.getEvent().getName();
        String targetMethodAnnotation = "@javax.portlet.ProcessEvent(name=" + eventName + ")";
        for (Method method : methods) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = method.getAnnotations()) {
                if (!((Object)annotation).toString().equals(targetMethodAnnotation)) continue;
                try {
                    method.invoke((Object)this, request, response);
                    return;
                }
                catch (Exception e) {
                    throw new PortletException(e);
                }
            }
        }
        response.setRenderParameters(request);
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
    }
}

