/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

public class MultivaluedHashMap<K, V>
extends HashMap<K, List<V>>
implements MultivaluedMap<K, V> {
    private static final long serialVersionUID = -6052320403766368902L;

    public MultivaluedHashMap() {
    }

    public MultivaluedHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public MultivaluedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public MultivaluedHashMap(MultivaluedMap<? extends K, ? extends V> map) {
        this.putAll(map);
    }

    @Override
    private <T extends K, U extends V> void putAll(MultivaluedMap<T, U> map) {
        for (Map.Entry e : map.entrySet()) {
            this.put(e.getKey(), new ArrayList((Collection)e.getValue()));
        }
    }

    public MultivaluedHashMap(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.putSingle(e.getKey(), e.getValue());
        }
    }

    @Override
    public final void putSingle(K key, V value) {
        List<V> values = this.getValues(key);
        values.clear();
        if (value != null) {
            values.add(value);
        } else {
            this.addNull(values);
        }
    }

    protected void addNull(List<V> values) {
    }

    protected void addFirstNull(List<V> values) {
    }

    @Override
    public final void add(K key, V value) {
        List<V> values = this.getValues(key);
        if (value != null) {
            values.add(value);
        } else {
            this.addNull(values);
        }
    }

    public final void addAll(K key, V ... newValues) {
        if (newValues == null || newValues.length == 0) {
            return;
        }
        List<V> values = this.getValues(key);
        for (V value : newValues) {
            if (value != null) {
                values.add(value);
                continue;
            }
            this.addNull(values);
        }
    }

    public final void addAll(K key, List<V> valueList) {
        if (valueList == null || valueList.isEmpty()) {
            return;
        }
        List<V> values = this.getValues(key);
        for (V value : valueList) {
            if (value != null) {
                values.add(value);
                continue;
            }
            this.addNull(values);
        }
    }

    @Override
    public final V getFirst(K key) {
        List values = (List)this.get(key);
        if (values != null && values.size() > 0) {
            return (V)values.get(0);
        }
        return null;
    }

    public final void addFirst(K key, V value) {
        List<V> values = this.getValues(key);
        if (value != null) {
            values.add(0, value);
        } else {
            this.addFirstNull(values);
        }
    }

    protected final List<V> getValues(K key) {
        LinkedList l = (LinkedList)this.get(key);
        if (l == null) {
            l = new LinkedList();
            this.put(key, l);
        }
        return l;
    }
}

