/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.CharacterReference;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Source;
import au.id.jericho.lib.html.Tag;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Writer;

public final class Attribute
extends Segment {
    private final String key;
    private final Segment nameSegment;
    private final Segment valueSegment;
    private final Segment valueSegmentIncludingQuotes;
    static final String CHECKED = "checked";
    static final String CLASS = "class";
    static final String DISABLED = "disabled";
    static final String ID = "id";
    static final String MULTIPLE = "multiple";
    static final String NAME = "name";
    static final String SELECTED = "selected";
    static final String STYLE = "style";
    static final String TYPE = "type";
    static final String VALUE = "value";

    Attribute(Source source, String key, Segment nameSegment) {
        this(source, key, nameSegment, null, null);
    }

    Attribute(Source source, String key, Segment nameSegment, Segment valueSegment, Segment valueSegmentIncludingQuotes) {
        super(source, nameSegment.getBegin(), valueSegmentIncludingQuotes == null ? nameSegment.getEnd() : valueSegmentIncludingQuotes.getEnd());
        this.key = key;
        this.nameSegment = nameSegment;
        this.valueSegment = valueSegment;
        this.valueSegmentIncludingQuotes = valueSegmentIncludingQuotes;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.nameSegment.toString();
    }

    public Segment getNameSegment() {
        return this.nameSegment;
    }

    public boolean hasValue() {
        return this.valueSegment != null;
    }

    public String getValue() {
        return CharacterReference.decode(this.valueSegment, true);
    }

    public Segment getValueSegment() {
        return this.valueSegment;
    }

    public Segment getValueSegmentIncludingQuotes() {
        return this.valueSegmentIncludingQuotes;
    }

    public char getQuoteChar() {
        if (this.valueSegment == this.valueSegmentIncludingQuotes) {
            return ' ';
        }
        return this.source.charAt(this.valueSegmentIncludingQuotes.getBegin());
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer().append(this.key).append(super.getDebugInfo()).append(",name=").append(this.nameSegment.getDebugInfo());
        if (this.hasValue()) {
            sb.append(",value=").append(this.valueSegment.getDebugInfo()).append('\"').append((Object)this.valueSegment).append("\"\n");
        } else {
            sb.append(",NO VALUE\n");
        }
        return sb.toString();
    }

    Tag appendTidy(StringBuffer sb, Tag nextTag) {
        sb.append(' ');
        Util.appendTo(sb, (CharSequence)this.nameSegment);
        if (this.valueSegment != null) {
            sb.append("=\"");
            while (nextTag != null && nextTag.begin < this.valueSegment.begin) {
                nextTag = nextTag.findNextTag();
            }
            if (nextTag == null || nextTag.begin >= this.valueSegment.end) {
                Attribute.appendTidyValue(sb, this.valueSegment);
            } else {
                int i = this.valueSegment.begin;
                while (nextTag != null && nextTag.begin < this.valueSegment.end) {
                    Attribute.appendTidyValue(sb, new Segment(this.source, i, nextTag.begin));
                    if (nextTag.end > this.valueSegment.end) {
                        i = this.valueSegment.end;
                        sb.append((Object)new Segment(this.source, nextTag.begin, i));
                        break;
                    }
                    sb.append((Object)nextTag);
                    i = nextTag.end;
                    nextTag = nextTag.findNextTag();
                }
                if (i < this.valueSegment.end) {
                    Attribute.appendTidyValue(sb, new Segment(this.source, i, this.valueSegment.end));
                }
            }
            sb.append('\"');
        }
        return nextTag;
    }

    private static void appendTidyValue(StringBuffer sb, CharSequence unencodedValue) {
        CharacterReference.appendEncode(sb, CharacterReference.decode(unencodedValue, true), false);
    }

    static StringBuffer appendHTML(StringBuffer sb, CharSequence name, CharSequence value) {
        sb.append(' ');
        Util.appendTo(sb, name);
        if (value != null) {
            sb.append("=\"");
            CharacterReference.appendEncode(sb, value, false);
            sb.append('\"');
        }
        return sb;
    }

    static Writer appendHTML(Writer writer, CharSequence name, CharSequence value) throws IOException {
        writer.write(32);
        Util.appendTo(writer, name);
        if (value != null) {
            writer.write("=\"");
            writer.write(CharacterReference.encode(value));
            writer.write(34);
        }
        return writer;
    }
}

