/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.Segment;
import java.io.IOException;
import java.io.Writer;

final class BlankOutputSegment
implements OutputSegment {
    private int begin;
    private int end;

    public BlankOutputSegment(int begin, int end) {
        this.begin = begin;
        this.end = end;
    }

    public BlankOutputSegment(Segment segment) {
        this(segment.getBegin(), segment.getEnd());
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void writeTo(Writer writer) throws IOException {
        for (int i = this.begin; i < this.end; ++i) {
            writer.write(32);
        }
    }

    public long getEstimatedMaximumOutputLength() {
        return this.end - this.begin;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.end - this.begin);
        for (int i = this.begin; i < this.end; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public String getDebugInfo() {
        return "(" + this.begin + ',' + this.end + ')';
    }
}

