/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Source;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

final class EncodedSource {
    public final Reader Reader;
    public final String Encoding;
    public final String EncodingSpecificationInfo;
    public final HttpURLConnection HttpURLConnection;
    private static final int PREVIEW_BUFFER_SIZE = 2048;
    private static final int PREVIEW_MAX_BYTES = 8192;
    private static final String UTF_32 = "UTF-32";
    private static final String UTF_16 = "UTF-16";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_8 = "UTF-8";
    private static final String EBCDIC = "Cp037";
    private static final String ISO_8859_1 = "ISO-8859-1";

    EncodedSource(InputStream inputStream, String encoding, String encodingSpecificationInfo, HttpURLConnection httpURLConnection) throws UnsupportedEncodingException {
        this.Reader = encoding == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, encoding);
        this.Encoding = encoding;
        this.EncodingSpecificationInfo = encodingSpecificationInfo;
        this.HttpURLConnection = httpURLConnection;
    }

    public static EncodedSource construct(URL url) throws IOException {
        String charset;
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection httpURLConnection = urlConnection instanceof HttpURLConnection ? (HttpURLConnection)urlConnection : null;
        InputStream inputStream = urlConnection.getInputStream();
        String contentType = urlConnection.getContentType();
        if (contentType != null && (charset = Source.getCharsetParameterFromHttpHeaderValue(contentType)) != null) {
            return new EncodedSource(inputStream, charset, "HTTP header Content-Type: " + contentType, httpURLConnection);
        }
        return EncodedSource.construct(inputStream, httpURLConnection);
    }

    public static EncodedSource construct(InputStream inputStream, HttpURLConnection httpURLConnection) throws IOException {
        BufferedInputStream in = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        in.mark(8192);
        String preliminaryEncoding = EncodedSource.getPreliminaryEncoding(in);
        if (preliminaryEncoding == null) {
            return new EncodedSource(in, null, "empty input stream", httpURLConnection);
        }
        in.reset();
        Source previewSource = EncodedSource.getPreviewSource(in, preliminaryEncoding);
        in.reset();
        if (previewSource.getEncoding() != null) {
            return new EncodedSource(in, previewSource.encoding, previewSource.encodingSpecificationInfo, httpURLConnection);
        }
        if (httpURLConnection != null && preliminaryEncoding == UTF_8 && !previewSource.isXML()) {
            return new EncodedSource(in, ISO_8859_1, "HTTP default 8-bit encoding for non-XML document", httpURLConnection);
        }
        return new EncodedSource(in, preliminaryEncoding, "XML default matching first four bytes of input stream", httpURLConnection);
    }

    private static String getPreliminaryEncoding(BufferedInputStream bufferedInputStream) throws IOException {
        int b1 = bufferedInputStream.read();
        if (b1 == -1) {
            return null;
        }
        int b2 = bufferedInputStream.read();
        int b3 = bufferedInputStream.read();
        int b4 = bufferedInputStream.read();
        if ((b1 & 0xFE) == 254 && b2 == (b1 ^ 1)) {
            return b3 == 0 ? UTF_32 : UTF_16;
        }
        if (b1 == 0) {
            if (b2 == 0 || b4 == 0) {
                return UTF_32;
            }
            return UTF_16BE;
        }
        if (b2 == 0) {
            return b3 == 0 ? UTF_32 : UTF_16LE;
        }
        if (b1 == 76 && b2 == 111 && b3 == 167 && b4 == 148) {
            return EBCDIC;
        }
        return UTF_8;
    }

    private static Source getPreviewSource(BufferedInputStream bufferedInputStream, String preliminaryEncoding) throws IOException {
        int ch;
        BufferedReader preliminaryReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, preliminaryEncoding), 2048);
        StringBuffer sb = new StringBuffer(2048);
        for (int i = 0; i < 2048 && (ch = preliminaryReader.read()) != -1; ++i) {
            sb.append((char)ch);
        }
        return new Source(sb);
    }
}

