/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.OutputSegment;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.Util;
import java.io.IOException;
import java.io.Writer;

public final class StringOutputSegment
implements OutputSegment {
    private int begin;
    private int end;
    private CharSequence text;

    public StringOutputSegment(int begin, int end, CharSequence text) {
        this.begin = begin;
        this.end = end;
        this.text = text == null ? "" : text;
    }

    public StringOutputSegment(Segment segment, CharSequence text) {
        this(segment.begin, segment.end, text);
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public void writeTo(Writer writer) throws IOException {
        Util.appendTo(writer, this.text);
    }

    public long getEstimatedMaximumOutputLength() {
        return this.text.length();
    }

    public String toString() {
        return ((Object)this.text).toString();
    }

    public String getDebugInfo() {
        return "(" + this.begin + ',' + this.end + "):\"" + this.text + '\"';
    }

    public void output(Writer writer) throws IOException {
        this.writeTo(writer);
    }
}

