/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.common.http.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.finconsgroup.itserr.criterion.common.http.config.PropagatingRestTemplateProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HeaderPropagatingInterceptor
implements ClientHttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HeaderPropagatingInterceptor.class);
    private final PropagatingRestTemplateProperties properties;

    public HeaderPropagatingInterceptor(PropagatingRestTemplateProperties properties) {
        this.properties = properties;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.propagateHeaders(request);
        this.addInternalAuthHeader(request);
        return execution.execute(request, body);
    }

    private void propagateHeaders(HttpRequest request) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            return;
        }
        HttpServletRequest incomingRequest = attributes.getRequest();
        for (String headerName : this.properties.getPropagateHeaders()) {
            String headerValue = incomingRequest.getHeader(headerName);
            if (headerValue == null || headerValue.isEmpty()) continue;
            request.getHeaders().set(headerName, headerValue);
            log.debug("Propagated header '{}' to outgoing request", (Object)headerName);
        }
    }

    private void addInternalAuthHeader(HttpRequest request) {
        PropagatingRestTemplateProperties.InternalAuthProperties internalConfig = this.properties.getInternal();
        if (!internalConfig.isEnabled()) {
            return;
        }
        if (internalConfig.getSecret() == null || internalConfig.getSecret().isEmpty()) {
            log.warn("Internal auth enabled but no secret configured!");
            return;
        }
        request.getHeaders().set(internalConfig.getHeaderName(), internalConfig.getSecret());
        log.debug("Added internal auth header to outgoing request");
    }
}

