package org.finconsgroup.itserr.criterion.common.service.impl;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.finconsgroup.itserr.criterion.common.client.NotificationClient;
import org.finconsgroup.itserr.criterion.common.dto.NotificationDto;
import org.finconsgroup.itserr.criterion.common.dto.RequestNotificationDto;
import org.finconsgroup.itserr.criterion.common.exception.WP3GenericException;
import org.finconsgroup.itserr.criterion.common.service.CommonNotificationService;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.UUID;

@Slf4j
@Service
@RequiredArgsConstructor
public class DefaultNotificationService implements CommonNotificationService {

    private final NotificationClient clientService;

    @Override
    public List<NotificationDto> createNotification(RequestNotificationDto requestNotificationDto) {
        String verifyMessage = "";

        verifyMessage = verifyNotificationField(requestNotificationDto);

        if (!verifyMessage.isEmpty()) {
            throw new WP3GenericException(verifyMessage);
        }

        return clientService.createNotification(requestNotificationDto);
    }

    @Override
    public NotificationDto updateNotification(UUID notificationId) {
        if (notificationId == null) {
            throw new WP3GenericException("Notificatiion ID cannot be null");
        }

        return clientService.updateNotification(notificationId);
    }

    public String verifyNotificationField(RequestNotificationDto requestNotificationDto) {
        if (requestNotificationDto == null) {
            return "Notification object cannot be null";
        }
        if (requestNotificationDto.getNotificationEventId() == null || requestNotificationDto.getNotificationEventId() == 0) {
            return "Select nofitication event";
        }

        return notificationVerifyBaseFields(requestNotificationDto);
    }

    public String notificationVerifyBaseFields(RequestNotificationDto notificationDto) {

        if (notificationDto.getNotificationEventId() == null) {
            return "Notification event cannot be empty.";
        }


        if (notificationDto.getNotificationOwnerId() == null) {
            return "Owner cannot be empty.";
        }

        if (notificationDto.getNotificationEventId() < 1 || notificationDto.getNotificationEventId() > 12) {
            return "notificationEventId must be between 1 and 12 (inclusive)";
        }

        switch (notificationDto.getNotificationEventId()) {
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12:
                if (notificationDto.getRecipientUserId() == null) {
                    return "Recipient User cannot be null";
                }
                break;
            case 10:
                if (notificationDto.getRecipientUserId() == null) {
                    return "Recipient User cannot be null";
                }
                if (notificationDto.getDocumentId() == null) {
                    return "Document cannot be null";
                }
                break;
            default:
                return "Event not valid";
        }

        return "";
    }

}
