package org.finconsgroup.itserr.criterion.common.util;

public enum Constants {

    WELCOME_SUBJECT("Welcome to Criterion – Your account is active!"),
    WELCOME_MESSAGE("Welcome to Criterion – Your account is active! <br><br>Hello <b>{{userName}} {{userSurname}},\n\n" +
            "<br><br>Your Criterion account has been successfully created!</b>\n\n" +
            "<br><br>Now you can start:\n" +
            "<br>* Creating critical edition documents\n" +
            "<br>* Inviting expert collaborators\n" +
            "<br>* Sharing apparatus and annotations in a structured and secure way\n\n" +
            "<br><br>If you did not request this registration, please ignore this email.\n\n" +
            "<br><br><hr>\n\n" +
            "<br>This email was sent automatically by Criterion. <br>Do not reply to this message.\n" +
            "<br><b>© {{currentYear}} Criterion – All rights reserved.</b>"),
    LOCAL("local"),
    CHANGE_PASSWORD_SUBJECT("Change password on Criterion"),
    CHANGE_PASSWORD_MESSAGE("Dear user your password has change successful!"),
    ACTIVE_STATUS("Active"),
    RESET_STATUS("Reset"),
    DELETED_STATUS("Deleted"),
    INACTIVE_STATUS("Inactive"),
    UNVERIFIED_STATUS("Unverified"),
    VERIFICATION_EMAIL_SUBJECT("Verify your Criterion email"),
    VERIFICATION_EMAIL_MESSAGE("\t\n" +
            "Hi there,\n" +
            "\n" +
            "<br><br><b>You recently tried to register an account on Criterion platform.</b>\n" +
            "\n" +
            "<br><br>Your verification code is:\n" +
            "<br><b>{{code}}</b>\n" +
            "\n" +
            "<br><br>This code will expire in 16 minutes. Please enter it in the Criterion application to proceed with email verification.\n" +
            "\n" +
            "<br><br>Thank you for using Criterion!\n" +
            "\n" +
            "<br><br>— The Criterion Team\n" +
            "<br><br><hr>\n\n" +
            "<br>This email was sent automatically by Criterion. <br>Do not reply to this message.\n" +
            "<br><b>© {{currentYear}} Criterion – All rights reserved.</b>"),
    RESET_PASSWORD_SUBJECT("Reset your Criterion password"),
    RESET_PASSWORD_MESSAGE("\t\n" +
            "Hi there,\n" +
            "\n" +
            "<br><br><b>You recently requested to reset your password for your Criterion account.</b>\n" +
            "\n" +
            "<br><br>Your verification code is:\n" +
            "<br><br><b>{{code}}</b>\n" +
            "\n" +
            "<br><br>This code will expire in <b>16 minutes.</b> Please enter it in the Criterion application to proceed with setting a new password.\n" +
            "\n" +
            "<br><br>If you didn't request a password reset, you can safely ignore this message. Your account remains secure, and no changes have been made.\n" +
            "\n" +
            "<br><br>Thank you for using Criterion!\n" +
            "\n" +
            "<br><br>— The Criterion Team\n" +
            "<br><br><hr>\n\n" +
            "<br>This email was sent automatically by Criterion. <br>Do not reply to this message.\n" +
            "<br><b>© {{currentYear}} Criterion – All rights reserved.</b>"),
    UPLOAD_DOCUMENT_SUBJECT("Upload your document to Criterion"),
    UPLOAD_DOCUMENT_MESSAGE("\t\n" +
            "Hi there,\n" +
            "\n" +
            "Your document:\n" +
            "<b>{{code}}</b>\n" +
            "\n" +
            "It has been successfully uploaded to the Critertion system.\n" +
            "\n" +
            "Thank you for using Criterion!\n" +
            "\n" +
            "— The Criterion Team\n" +
            "──────────────────────────────────────────────────────────────────────────\n\n" +
            "\n" +
            "ℹ️ This is an automated message. Please do not reply to this email."),
    NOTIFICATION_EVENT_SEND_INVITATION("1"),
    NOTIFICATION_EVENT_RESEND_INVITATION("2"),
    NOTIFICATION_EVENT_REVOKE_ACCESS("3"),
    NOTIFICATION_EVENT_SHARE_NEW_VERSION("4"),
    NOTIFICATION_EVENT_DELETE_DOCUMENT("5"),
    NOTIFICATION_EVENT_ACCEPT_INVITATION("6"),
    NOTIFICATION_EVENT_DECLINE_INVITATION("7"),
    NOTIFICATION_EVENT_DOWNLOAD("8"),
    NOTIFICATION_EVENT_DOWNLOAD_NEW_VERSION("9"),
    NOTIFICATION_EVENT_INVITATION_EXPIRED("10"),
    NOTIFICATION_EVENT_PASSWORD_CHANGED("11"),
    NOTIFICATION_EVENT_ACCOUNT_DELETED("12");

    private final String value;

    Constants(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
}