/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.common.exception;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.finconsgroup.itserr.criterion.common.dto.ErrorResponseDto;
import org.finconsgroup.itserr.criterion.common.exception.UnauthorizedException;
import org.finconsgroup.itserr.criterion.common.exception.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

public abstract class BaseExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ErrorResponseDto> handleValidationExceptions(MethodArgumentNotValidException ex, WebRequest request) {
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        ex.getBindingResult().getAllErrors().forEach(error -> {
            String fieldName = ((FieldError)error).getField();
            String errorMessage = error.getDefaultMessage();
            errorMessages.put(fieldName, errorMessage);
        });
        String path = this.extractPath(request);
        log.error("Validation errors: {} | Path: {}", errorMessages, (Object)path);
        ErrorResponseDto errorResponse = ErrorResponseDto.builder().errorCode(HttpStatus.BAD_REQUEST.value()).errorMessages(errorMessages).path(path).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)errorResponse);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorResponseDto> handleGenericException(Exception ex, WebRequest request) {
        String path = this.extractPath(request);
        log.error("Unexpected error: {} | Path: {}", new Object[]{ex.getMessage(), path, ex});
        ErrorResponseDto errorResponse = ErrorResponseDto.builder().errorCode(HttpStatus.INTERNAL_SERVER_ERROR.value()).errorMessages(Map.of("error", "An unexpected error occurred. Please contact support.")).path(path).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)errorResponse);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    public ResponseEntity<ErrorResponseDto> handleUnauthorizedException(UnauthorizedException ex, WebRequest request) {
        String path = this.extractPath(request);
        log.warn("UnauthorizedException: {} | Path: {}", (Object)ex.getMessage(), (Object)path);
        ErrorResponseDto errorResponse = ErrorResponseDto.builder().errorCode(HttpStatus.UNAUTHORIZED.value()).errorMessages(Map.of("error", ex.getMessage())).path(path).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)errorResponse);
    }

    protected String extractPath(WebRequest request) {
        String description = request.getDescription(false);
        if (description != null && description.startsWith("uri=")) {
            return description.substring(4);
        }
        return description;
    }

    @ExceptionHandler(value={UserNotFoundException.class})
    public ResponseEntity<ErrorResponseDto> handleUserNotFound(UserNotFoundException ex, WebRequest request) {
        String path = this.extractPath(request);
        log.error("UserNotFoundException: {} | Path: {}", (Object)ex.getMessage(), (Object)path);
        ErrorResponseDto errorResponse = ErrorResponseDto.builder().errorCode(HttpStatus.NOT_FOUND.value()).errorMessages(Map.of("error", ex.getMessage())).path(path).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)errorResponse);
    }
}

