/*
 * Decompiled with CFR 0.152.
 */
package org.finconsgroup.itserr.criterion.common.service.impl;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.finconsgroup.itserr.criterion.common.client.NotificationClient;
import org.finconsgroup.itserr.criterion.common.dto.NotificationDto;
import org.finconsgroup.itserr.criterion.common.dto.RequestNotificationDto;
import org.finconsgroup.itserr.criterion.common.exception.WP3GenericException;
import org.finconsgroup.itserr.criterion.common.service.CommonNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultNotificationService
implements CommonNotificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationService.class);
    private final NotificationClient clientService;

    @Override
    public List<NotificationDto> createNotification(RequestNotificationDto requestNotificationDto) {
        String verifyMessage = "";
        verifyMessage = this.verifyNotificationField(requestNotificationDto);
        if (!verifyMessage.isEmpty()) {
            throw new WP3GenericException(verifyMessage);
        }
        return this.clientService.createNotification(requestNotificationDto);
    }

    @Override
    public NotificationDto updateNotification(UUID notificationId) {
        if (notificationId == null) {
            throw new WP3GenericException("Notificatiion ID cannot be null");
        }
        return this.clientService.updateNotification(notificationId);
    }

    public String verifyNotificationField(RequestNotificationDto requestNotificationDto) {
        if (requestNotificationDto == null) {
            return "Notification object cannot be null";
        }
        if (requestNotificationDto.getNotificationEventId() == null || requestNotificationDto.getNotificationEventId() == 0) {
            return "Select nofitication event";
        }
        return this.notificationVerifyBaseFields(requestNotificationDto);
    }

    public String notificationVerifyBaseFields(RequestNotificationDto notificationDto) {
        if (notificationDto.getNotificationEventId() == null) {
            return "Notification event cannot be empty.";
        }
        if (notificationDto.getNotificationOwnerId() == null) {
            return "Owner cannot be empty.";
        }
        if (notificationDto.getNotificationEventId() < 1 || notificationDto.getNotificationEventId() > 12) {
            return "notificationEventId must be between 1 and 12 (inclusive)";
        }
        switch (notificationDto.getNotificationEventId()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                if (notificationDto.getRecipientUserId() != null) break;
                return "Recipient User cannot be null";
            }
            case 10: {
                if (notificationDto.getRecipientUserId() == null) {
                    return "Recipient User cannot be null";
                }
                if (notificationDto.getDocumentId() != null) break;
                return "Document cannot be null";
            }
            default: {
                return "Event not valid";
            }
        }
        return "";
    }

    @Generated
    public DefaultNotificationService(NotificationClient clientService) {
        this.clientService = clientService;
    }
}

