package org.finconsgroup.itserr.criterion.security.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * DTO sent to the external authorization service.
 * Contains all relevant information about the request being authorized.
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AuthorizationRequest {

    /**
     * Original Authorization header from the incoming request (e.g., Bearer token)
     */
    private String authorizationHeader;

    /**
     * Request URI (e.g., /api/orders/123)
     */
    private String requestUri;

    /**
     * HTTP method (GET, POST, PUT, DELETE, etc.)
     */
    private String httpMethod;

    /**
     * Client IP address
     */
    private String remoteAddress;

    /**
     * Target method name in the controller
     */
    private String targetMethod;

    /**
     * Fully qualified class name of the controller
     */
    private String targetClass;

    /**
     * Client User-Agent header
     */
    private String userAgent;

    /**
     * Correlation ID for distributed tracing
     */
    private String correlationId;
}