package org.finconsgroup.itserr.criterion.security.config;

import org.finconsgroup.itserr.criterion.security.health.ExternalAuthHealthIndicator;
import org.finconsgroup.itserr.criterion.security.service.ExternalAuthService;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

/**
 * Separate auto-configuration for Health Indicator.
 * Only loaded when Actuator is on the classpath.
 */
@AutoConfiguration
@ConditionalOnClass(name = "org.springframework.boot.actuate.health.HealthIndicator")
@ConditionalOnBean(ExternalAuthService.class)
public class ExternalAuthHealthAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public ExternalAuthHealthIndicator externalAuthHealthIndicator(ExternalAuthService externalAuthService) {
        return new ExternalAuthHealthIndicator(externalAuthService);
    }
}