package com.finconsgroup.itserr.marketplace.metadata.integration.client.metadatadm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Metadata field DTO.
 */
@Schema(
        name = "MetadataField",
        description = "A field of a metadata"
)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetadataFieldDmDto {

    /** Name field length. */
    public static final int NAME_LENGTH = 50;
    /** Description field length. */
    public static final int DESCRIPTION_LENGTH = 255;

    @Schema(description = "Field name")
    @NotBlank
    @Size(max = NAME_LENGTH)
    private String name;

    @Schema(description = "Description")
    @Size(max = DESCRIPTION_LENGTH)
    private String description;

    @Schema(description = "Type of the field expected value")
    @NotNull
    private OutputMetadataFieldDmType type;

    @Schema(description = """
                List of terms that are allowed as values, or null/empty for any available.
                This should be alternative to 'validation'.
            """)
    private List<String> vocabulary;

    @Schema(description = """
             A regex that the value should comply with.
             This should be alternative to 'vocabulary'.
            """)
    private String validation;

    @Schema(
            description = "true if the metadata value is mandatory, false otherwise",
            defaultValue = "false")
    private boolean mandatory;

}
