package com.finconsgroup.itserr.marketplace.discussion.bs.enums;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

public enum ResourceType {
    NEWS("news"),
    INSTITUTIONAL_PAGE("institutionalPage"),
    EVENT("event"),
    ITEM("item"),
    FOLDER("folder"),
    DOCUMENT("document");

    private final String value;

    ResourceType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @JsonCreator
    public static ResourceType fromValue(String value) {
        for (ResourceType type : ResourceType.values()) {
            if (type.value.equalsIgnoreCase(value)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unknown resource type: " + value);
    }

    @Override
    public String toString() {
        return value;
    }

    @Component
    public static class ResourceTypeConverter implements Converter<String, ResourceType> {
        @Override
        public @Nullable ResourceType convert(@NonNull String source) {
            return ResourceType.fromValue(source);
        }
    }
}
