package com.finconsgroup.itserr.marketplace.discussion.bs.utils;

import com.fasterxml.jackson.annotation.JsonValue;

public enum OperationType {
    CREATE("Create"),
    UPDATE("Update"),
    DELETE("Delete");

    private final String value;

    OperationType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public static OperationType fromValue(String value) {
        for (OperationType status : values()) {
            if (status.value.equals(value)) {
                return status;
            }
        }

        throw new IllegalArgumentException("Unknown operation type: " + value);
    }
}