/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.discussion.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionApplicationEvent;
import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionThreadApplicationEvent;
import com.finconsgroup.itserr.marketplace.discussion.bs.bean.DiscussionThreadDetails;
import com.finconsgroup.itserr.marketplace.discussion.bs.client.dm.DiscussionDmClient;
import com.finconsgroup.itserr.marketplace.discussion.bs.client.dm.UserProfileDmClient;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionReactionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.InputFindUserProfilesByPrincipalsDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.InputUpdateDiscussionDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.ThreadDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.ThreadReactionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.dto.UserInfoDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.MessagingEventType;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ReactionType;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.ResourceType;
import com.finconsgroup.itserr.marketplace.discussion.bs.mapper.EventToDiscussionMapper;
import com.finconsgroup.itserr.marketplace.discussion.bs.mapper.UserProfileMapper;
import com.finconsgroup.itserr.marketplace.discussion.bs.service.DiscussionService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultDiscussionService
implements DiscussionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDiscussionService.class);
    private final DiscussionDmClient discussionDmClient;
    private final UserProfileDmClient userProfileDmClient;
    private final UserProfileMapper userProfileMapper;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final EventToDiscussionMapper eventToDiscussionMapper;

    public Page<DiscussionDTO> getDiscussions(int page, int size, String sortBy, String direction, String visibility, boolean includeThreads) {
        Page discussionDTOs = this.discussionDmClient.getDiscussions(page, size, sortBy, direction, visibility, includeThreads);
        this.fillDiscussionDTOs(includeThreads, true, discussionDTOs.getContent());
        return discussionDTOs;
    }

    public DiscussionDTO getDiscussionForResource(String resourceId, ResourceType resourceType) {
        DiscussionDTO discussionDTO = this.discussionDmClient.getDiscussionForResource(resourceId, resourceType.getValue());
        ArrayList<String> preferredNames = new ArrayList<String>();
        preferredNames.add(discussionDTO.getCreatedBy());
        preferredNames.addAll(DefaultDiscussionService.getListPreferredNameFromDiscussionReaction((DiscussionDTO)discussionDTO));
        Optional.ofNullable(discussionDTO.getThreads()).orElse(List.of()).forEach(thread -> {
            preferredNames.addAll(this.collectPrincipalsRecursively(thread));
            preferredNames.addAll(this.collectReactionUserIdsRecursively(thread));
        });
        if (!preferredNames.isEmpty()) {
            InputFindUserProfilesByPrincipalsDto inputDto = InputFindUserProfilesByPrincipalsDto.builder().principals(preferredNames).build();
            int profilesPage = 0;
            int profilesSize = preferredNames.size();
            List profiles = this.userProfileDmClient.findAllByPrincipals(inputDto, profilesPage, profilesSize, "preferredUsername", "ASC").getContent();
            Map<String, UserInfoDTO> usernameToUserInfo = profiles.stream().filter(p -> p.getPreferredUsername() != null && !p.getPreferredUsername().isBlank()).collect(Collectors.toMap(p -> p.getPreferredUsername(), p -> this.userProfileMapper.toUserInfoDTO(p), (a, b) -> a));
            DefaultDiscussionService.setUserInfoDiscussion(usernameToUserInfo, (DiscussionDTO)discussionDTO);
            DefaultDiscussionService.setDiscussionReactionUserInfo(usernameToUserInfo, (DiscussionDTO)discussionDTO);
            this.setThreadAndReactionUserInfo(true, usernameToUserInfo, discussionDTO);
        }
        return discussionDTO;
    }

    public Page<ThreadDTO> getThreadsByDiscussionId(String discussionId, int page, int size, String sortBy, Sort.Direction direction) {
        Page threadDTOS = this.discussionDmClient.getThreadsByDiscussionId(discussionId, page, size, sortBy, direction);
        List createdByList = threadDTOS.getContent().stream().flatMap(thread -> this.collectPrincipalsRecursively(thread).stream()).filter(createdBy -> createdBy != null && !createdBy.isBlank()).distinct().collect(Collectors.toList());
        List reactionUserIds = threadDTOS.getContent().stream().flatMap(thread -> this.collectReactionUserIdsRecursively(thread).stream()).filter(userId -> userId != null && !userId.isBlank()).distinct().collect(Collectors.toList());
        createdByList.addAll(reactionUserIds);
        createdByList = createdByList.stream().distinct().collect(Collectors.toList());
        if (!createdByList.isEmpty()) {
            InputFindUserProfilesByPrincipalsDto inputDto = InputFindUserProfilesByPrincipalsDto.builder().principals(createdByList).build();
            int profilesPage = 0;
            int profilesSize = createdByList.size();
            List profiles = this.userProfileDmClient.findAllByPrincipals(inputDto, profilesPage, profilesSize, "preferredUsername", String.valueOf(direction)).getContent();
            Map<String, UserInfoDTO> usernameToUserInfo = profiles.stream().filter(p -> p.getPreferredUsername() != null && !p.getPreferredUsername().isBlank()).collect(Collectors.toMap(p -> p.getPreferredUsername(), p -> this.userProfileMapper.toUserInfoDTO(p), (a, b) -> a));
            threadDTOS.getContent().forEach(thread -> {
                this.applyUserInfoRecursively(thread, usernameToUserInfo);
                this.applyReactionUserInfoRecursively(thread, usernameToUserInfo);
            });
        }
        return threadDTOS;
    }

    private List<String> collectPrincipalsRecursively(ThreadDTO thread) {
        ArrayList<String> list = new ArrayList<String>();
        if (thread == null) {
            return list;
        }
        if (thread.getCreatedBy() != null && !thread.getCreatedBy().isBlank()) {
            list.add(thread.getCreatedBy());
        }
        if (thread.getReplies() != null) {
            for (ThreadDTO reply : thread.getReplies()) {
                list.addAll(this.collectPrincipalsRecursively(reply));
            }
        }
        return list;
    }

    private void applyUserInfoRecursively(ThreadDTO thread, Map<String, UserInfoDTO> usernameToUserInfo) {
        UserInfoDTO info;
        if (thread == null || usernameToUserInfo == null) {
            return;
        }
        String createdBy = thread.getCreatedBy();
        if (createdBy != null && (info = usernameToUserInfo.get(createdBy)) != null) {
            thread.setUserInfoDTO(info);
        }
        if (thread.getReplies() != null) {
            for (ThreadDTO reply : thread.getReplies()) {
                this.applyUserInfoRecursively(reply, usernameToUserInfo);
            }
        }
    }

    public DiscussionDTO createDiscussion(DiscussionDTO discussionDTO) {
        String username = JwtTokenHolder.getPreferredUsernameOrThrow();
        discussionDTO.setCreatedBy(username);
        discussionDTO.setUpdatedBy(username);
        DiscussionDTO outputDiscussionDTO = this.discussionDmClient.createDiscussion(discussionDTO);
        this.fillDiscussionDTOs(false, false, List.of(outputDiscussionDTO));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new DiscussionApplicationEvent(outputDiscussionDTO, MessagingEventType.CREATED));
        return outputDiscussionDTO;
    }

    public DiscussionDTO updateDiscussion(String id, InputUpdateDiscussionDto discussionDTO) {
        DiscussionDTO updatedDiscussionDTO = this.discussionDmClient.updateDiscussion(id, discussionDTO, false);
        log.info("updated discussion: {}", (Object)updatedDiscussionDTO);
        this.fillDiscussionDTOs(false, true, List.of(updatedDiscussionDTO));
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new DiscussionApplicationEvent(updatedDiscussionDTO, MessagingEventType.UPDATED));
        return updatedDiscussionDTO;
    }

    public ResponseEntity<Void> deleteDiscussion(String id) {
        ResponseEntity response = this.discussionDmClient.deleteDiscussion(id);
        DiscussionDTO discussionDTO = DiscussionDTO.builder().id(UUID.fromString(id)).build();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new DiscussionApplicationEvent(discussionDTO, MessagingEventType.DELETED));
        return response;
    }

    public DiscussionDTO getDiscussion(String id) {
        DiscussionDTO discussionDTO = this.discussionDmClient.getDiscussionById(id, false);
        this.fillDiscussionDTOs(false, true, List.of(discussionDTO));
        return discussionDTO;
    }

    public ResponseEntity<ThreadDTO> addThread(String discussionId, ThreadDTO threadDTO) {
        ResponseEntity response = this.discussionDmClient.addThread(discussionId, threadDTO);
        if (response.getStatusCode().is2xxSuccessful()) {
            Optional.of(this.discussionDmClient.getDiscussionByDiscussionId(discussionId)).ifPresent(discussion -> {
                Set usersToNotify = this.collectUsersToNotify(discussion, threadDTO);
                DiscussionThreadDetails discussionThreadDetails = this.eventToDiscussionMapper.toDiscussionThreadDetails((ThreadDTO)response.getBody(), discussion, usersToNotify);
                this.fillDiscussionDTOs(false, true, List.of(discussion));
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new DiscussionThreadApplicationEvent(discussion, discussionThreadDetails, MessagingEventType.THREAD_CREATED));
            });
        }
        return ResponseEntity.status((HttpStatusCode)response.getStatusCode()).body((Object)((ThreadDTO)response.getBody()));
    }

    private Set<String> collectUsersToNotify(DiscussionDTO discussion, ThreadDTO threadDTO) {
        HashSet<String> usersToNotify = new HashSet();
        Optional.ofNullable(discussion.getCreatedBy()).ifPresent(usersToNotify::add);
        if (threadDTO.getParentId() != null) {
            this.addInvolvedUsers(discussion.getThreads(), threadDTO.getParentId(), usersToNotify);
        }
        usersToNotify = usersToNotify.stream().filter(username -> !username.equals(this.getCurrentUserPreferredUsername())).collect(Collectors.toSet());
        log.info("collected users to be notified are: {}", (Object)String.join((CharSequence)", ", usersToNotify));
        return usersToNotify;
    }

    private void addInvolvedUsers(List<ThreadDTO> allDiscussionThreads, UUID parentThreadId, Set<String> usersToNotify) {
        this.flattenThreads(allDiscussionThreads).filter(thread -> thread.getId().equals(parentThreadId)).findFirst().ifPresent(parentThread -> {
            if (parentThread.getCreatedBy() != null && !parentThread.getCreatedBy().isEmpty()) {
                usersToNotify.add(parentThread.getCreatedBy());
            }
            if (parentThread.getReplies() != null) {
                parentThread.getReplies().stream().map(ThreadDTO::getCreatedBy).filter(Objects::nonNull).filter(createdBy -> !createdBy.isEmpty()).forEach(usersToNotify::add);
            }
        });
    }

    private Stream<ThreadDTO> flattenThreads(List<ThreadDTO> threads) {
        return threads == null ? Stream.empty() : threads.stream().flatMap(reply -> Stream.concat(Stream.of(reply), this.flattenThreads(reply.getReplies())));
    }

    private String getCurrentUserPreferredUsername() {
        return JwtTokenHolder.getPreferredUsername().orElse(null);
    }

    public ResponseEntity<Void> deleteThread(String discussionId, String threadId) {
        ResponseEntity response = this.discussionDmClient.deleteThread(discussionId, threadId);
        DiscussionDTO discussionDTO = this.discussionDmClient.getDiscussionById(discussionId, false);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new DiscussionApplicationEvent(discussionDTO, MessagingEventType.UPDATED));
        return response;
    }

    public ResponseEntity<ThreadDTO> updateThread(String discussionId, String threadId, ThreadDTO threadDTO) {
        return this.discussionDmClient.updateThread(discussionId, threadId, threadDTO);
    }

    public ResponseEntity<Void> addReactionToDiscussion(String discussionId, String userId, ReactionType reactionType) {
        ResponseEntity response = this.discussionDmClient.addReactionToDiscussion(discussionId, userId, reactionType);
        DiscussionDTO discussionDTO = this.discussionDmClient.getDiscussionById(discussionId, false);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new DiscussionApplicationEvent(discussionDTO, MessagingEventType.UPDATED));
        return response;
    }

    public ResponseEntity<Void> removeReactionFromDiscussion(String discussionId, String userId) {
        ResponseEntity response = this.discussionDmClient.removeReactionFromDiscussion(discussionId, userId);
        DiscussionDTO discussionDTO = this.discussionDmClient.getDiscussionById(discussionId, false);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new DiscussionApplicationEvent(discussionDTO, MessagingEventType.UPDATED));
        return response;
    }

    public ResponseEntity<Void> addReactionToThread(String discussionId, String threadId, String userId, ReactionType reactionType) {
        return this.discussionDmClient.addReactionToThread(discussionId, threadId, userId, reactionType);
    }

    public ResponseEntity<Void> removeReactionFromThread(String discussionId, String threadId, String userId) {
        return this.discussionDmClient.removeReactionFromThread(discussionId, threadId, userId);
    }

    private void fillDiscussionDTOs(boolean includeThreads, boolean includeReactions, List<DiscussionDTO> discussionDTOs) {
        List discussionReactionUserIds;
        List threadCreatedByIds = new ArrayList();
        List threadReactionUserIds = new ArrayList();
        List createdByIds = DefaultDiscussionService.getListOfPreferredNameFromDiscussion(discussionDTOs);
        List list = discussionReactionUserIds = includeReactions ? DefaultDiscussionService.getListPreferredNameFromDiscussionReaction(discussionDTOs) : List.of();
        if (includeThreads) {
            threadCreatedByIds = this.getListPreferredNameFromThreads(discussionDTOs);
            if (includeReactions) {
                threadReactionUserIds = this.getListPreferredNameFromThreadReaction(discussionDTOs);
            }
        }
        createdByIds.addAll(discussionReactionUserIds);
        createdByIds.addAll(threadCreatedByIds);
        createdByIds.addAll(threadReactionUserIds);
        createdByIds = createdByIds.stream().distinct().collect(Collectors.toList());
        if (!createdByIds.isEmpty()) {
            Map usernameToUserInfo = this.loadUserInfo(createdByIds);
            discussionDTOs.forEach(discussion -> {
                DefaultDiscussionService.setUserInfoDiscussion((Map)usernameToUserInfo, (DiscussionDTO)discussion);
                DefaultDiscussionService.setDiscussionReactionUserInfo((Map)usernameToUserInfo, (DiscussionDTO)discussion);
                this.setThreadAndReactionUserInfo(includeThreads, usernameToUserInfo, discussion);
            });
        }
    }

    private Map<String, UserInfoDTO> loadUserInfo(List<String> usernames) {
        Map<String, UserInfoDTO> usernameToUserInfo;
        InputFindUserProfilesByPrincipalsDto inputDto = InputFindUserProfilesByPrincipalsDto.builder().principals(usernames).build();
        try {
            int profilesPage = 0;
            int profilesSize = usernames.size();
            List profiles = this.userProfileDmClient.findAllByPrincipals(inputDto, profilesPage, profilesSize, "preferredUsername", "ASC").getContent();
            usernameToUserInfo = profiles.stream().filter(p -> p.getPreferredUsername() != null && !p.getPreferredUsername().isBlank()).collect(Collectors.toMap(OutputUserProfileDto::getPreferredUsername, arg_0 -> ((UserProfileMapper)this.userProfileMapper).toUserInfoDTO(arg_0), (a, b) -> a));
        }
        catch (Exception e) {
            log.error("Error while fetching user information: {}", (Object)e.getMessage(), (Object)e);
            usernameToUserInfo = usernames.stream().collect(Collectors.toMap(Function.identity(), username -> UserInfoDTO.builder().preferredUsername(username).build()));
        }
        return usernameToUserInfo;
    }

    private void setThreadAndReactionUserInfo(boolean includeThreads, Map<String, UserInfoDTO> usernameToUserInfo, DiscussionDTO discussion) {
        if (includeThreads && discussion.getThreads() != null) {
            discussion.getThreads().forEach(thread -> {
                this.applyUserInfoRecursively(thread, usernameToUserInfo);
                this.applyReactionUserInfoRecursively(thread, usernameToUserInfo);
            });
        }
    }

    private static void setDiscussionReactionUserInfo(Map<String, UserInfoDTO> usernameToUserInfo, DiscussionDTO discussion) {
        if (discussion.getReactions() != null) {
            discussion.getReactions().forEach(reaction -> {
                UserInfoDTO userInfo;
                if (reaction.getUserId() != null && (userInfo = (UserInfoDTO)usernameToUserInfo.get(reaction.getUserId())) != null) {
                    reaction.setUserInfoDTO(userInfo);
                }
            });
        }
    }

    private static void setUserInfoDiscussion(Map<String, UserInfoDTO> usernameToUserInfo, DiscussionDTO discussion) {
        UserInfoDTO userInfo;
        String createdBy = discussion.getCreatedBy();
        if (createdBy != null && (userInfo = usernameToUserInfo.get(createdBy)) != null) {
            discussion.setUserInfoDTO(userInfo);
        }
    }

    @NotNull
    private List<String> getListPreferredNameFromThreadReaction(List<DiscussionDTO> discussionDTOs) {
        List<String> threadReactionUserIds = discussionDTOs.stream().filter(discussion -> discussion.getThreads() != null).flatMap(discussion -> discussion.getThreads().stream()).flatMap(thread -> this.collectReactionUserIdsRecursively(thread).stream()).filter(userId -> userId != null && !userId.isBlank()).distinct().collect(Collectors.toList());
        return threadReactionUserIds;
    }

    @NotNull
    private List<String> getListPreferredNameFromThreads(List<DiscussionDTO> discussionDTOs) {
        List<String> threadCreatedByIds = discussionDTOs.stream().filter(discussion -> discussion.getThreads() != null).flatMap(discussion -> discussion.getThreads().stream()).flatMap(thread -> this.collectPrincipalsRecursively(thread).stream()).filter(createdBy -> createdBy != null && !createdBy.isBlank()).distinct().collect(Collectors.toList());
        return threadCreatedByIds;
    }

    @NotNull
    private static List<String> getListPreferredNameFromDiscussionReaction(List<DiscussionDTO> discussionDTOs) {
        List<String> discussionReactionUserIds = discussionDTOs.stream().filter(discussion -> discussion.getReactions() != null).flatMap(discussion -> discussion.getReactions().stream()).map(DiscussionReactionDTO::getUserId).filter(userId -> userId != null && !userId.isBlank()).distinct().collect(Collectors.toList());
        return discussionReactionUserIds;
    }

    @NotNull
    private static List<String> getListPreferredNameFromDiscussionReaction(DiscussionDTO discussionDTO) {
        List<String> discussionReactionUserIds = Optional.ofNullable(discussionDTO.getReactions()).orElse(Collections.emptyList()).stream().map(DiscussionReactionDTO::getUserId).filter(userId -> userId != null && !userId.isBlank()).distinct().collect(Collectors.toList());
        return discussionReactionUserIds;
    }

    @NotNull
    private static List<String> getListOfPreferredNameFromDiscussion(List<DiscussionDTO> discussionDTOs) {
        List<String> createdByIds = discussionDTOs.stream().map(DiscussionDTO::getCreatedBy).filter(createdBy -> createdBy != null && !createdBy.isBlank()).distinct().collect(Collectors.toList());
        return createdByIds;
    }

    private List<String> collectReactionUserIdsRecursively(ThreadDTO thread) {
        ArrayList<String> list = new ArrayList<String>();
        if (thread == null) {
            return list;
        }
        if (thread.getReactions() != null) {
            thread.getReactions().stream().map(ThreadReactionDTO::getUserId).filter(userId -> userId != null && !userId.isBlank()).forEach(list::add);
        }
        if (thread.getReplies() != null) {
            for (ThreadDTO reply : thread.getReplies()) {
                list.addAll(this.collectReactionUserIdsRecursively(reply));
            }
        }
        return list;
    }

    private void applyReactionUserInfoRecursively(ThreadDTO thread, Map<String, UserInfoDTO> usernameToUserInfo) {
        if (thread == null || usernameToUserInfo == null) {
            return;
        }
        if (thread.getReactions() != null) {
            thread.getReactions().forEach(reaction -> {
                UserInfoDTO userInfo;
                if (reaction.getUserId() != null && (userInfo = (UserInfoDTO)usernameToUserInfo.get(reaction.getUserId())) != null) {
                    reaction.setUserInfoDTO(userInfo);
                }
            });
        }
        if (thread.getReplies() != null) {
            for (ThreadDTO reply : thread.getReplies()) {
                this.applyReactionUserInfoRecursively(reply, usernameToUserInfo);
            }
        }
    }

    @Generated
    public DefaultDiscussionService(DiscussionDmClient discussionDmClient, UserProfileDmClient userProfileDmClient, UserProfileMapper userProfileMapper, ApplicationEventPublisher applicationEventPublisher, EventToDiscussionMapper eventToDiscussionMapper) {
        this.discussionDmClient = discussionDmClient;
        this.userProfileDmClient = userProfileDmClient;
        this.userProfileMapper = userProfileMapper;
        this.applicationEventPublisher = applicationEventPublisher;
        this.eventToDiscussionMapper = eventToDiscussionMapper;
    }
}

