package com.finconsgroup.itserr.marketplace.discussion.bs.bean;

import com.finconsgroup.itserr.marketplace.discussion.bs.dto.DiscussionDTO;
import com.finconsgroup.itserr.marketplace.discussion.bs.enums.MessagingEventType;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;

import java.time.Instant;

/**
 * Application event when a user action is taken on Discussion.
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class DiscussionApplicationEvent extends ApplicationEvent {

    private final MessagingEventType eventType;
    private final Instant eventTimestamp;

    public DiscussionApplicationEvent(@NonNull DiscussionDTO source,
                                      @NonNull MessagingEventType eventType) {
        super(source);
        this.eventType = eventType;
        this.eventTimestamp = Instant.now();
    }

    /**
     * The discussion on which the event occurred.
     *
     * @return the {@link DiscussionDTO}
     */
    public DiscussionDTO getDiscussion() {
        return (DiscussionDTO) getSource();
    }

}
