package com.finconsgroup.itserr.marketplace.discussion.dm.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.finconsgroup.itserr.marketplace.discussion.dm.enums.ReactionType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * Data Transfer Object for Discussion entity.
 * This DTO is used to transfer discussion data between different layers of the application.
 */
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Data
public class DiscussionDTO {

    /**
     * The universally unique identifier (UUID) for the discussion.
     */
    private UUID id;

    /**
     * The title of the discussion.
     */
    private String title;

    /**
     * The textual content of the discussion.
     */
    private String content;

    /**
     * The identifier of the user who created the discussion.
     */
    private String createdBy;

    /**
     * The date and time when the discussion was created.
     */
    private Instant createdAt;

    /**
     * The identifier of an external resource associated with the discussion.
     */
    private UUID resourceId;

    /**
     * The type of the external resource associated with the discussion.
     */
    private String resourceType;

    /**
     * The visibility setting of the discussion.
     */
    private String visibility;

    /**
     * The URL associated with the discussion.
     */
    private String url;

    /**
     * The identifier of the user who last updated the discussion.
     */
    private String updatedBy;

    /**
     * The date and time when the discussion was last updated.
     */
    private Instant updatedAt;

    /**
     * List of threads associated with this discussion.
     */
    private List<ThreadDTO> threads;

    /**
     * Number of top-level threads in this discussion.
     */
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @Schema(accessMode = Schema.AccessMode.READ_ONLY)
    private Long threadsCount;

    /**
     * List of reactions to this discussion.
     */
    private List<DiscussionReactionDTO> reactions;

    /**
     * Count of reactions grouped by reaction type.
     */
    @JsonProperty(access = JsonProperty.Access.READ_ONLY)
    @Schema(accessMode = Schema.AccessMode.READ_ONLY)
    private Map<ReactionType, Long> reactionCounts;
}
