package com.finconsgroup.itserr.marketplace.discussion.dm.repository;

import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Discussion;
import com.finconsgroup.itserr.marketplace.discussion.dm.entity.Thread;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.UUID;

/**
 * Repository interface for managing Thread entities in the persistence layer.
 * This interface extends JpaRepository to provide CRUD methods and additional
 * functionality, such as pagination and sorting, for Thread entities.
 *
 * The primary key of the Thread entity is of type UUID.
 *
 * Responsibilities:
 * - Handles database interactions for Thread entities.
 * - Simplifies queries and operations through Spring Data JPA.
 *
 * Annotations:
 * - {@code @Repository}: Marks this interface as a Spring-managed repository bean.
 *
 * Thread entity details:
 * - Represents a discussion thread in the system with hierarchical relationships,
 *   linked discussions, user-created content, and associated reactions.
 */
@Repository
public interface ThreadRepository extends JpaRepository<Thread, UUID> {
    List<Thread> findByDiscussion(Discussion discussion);
    Page<Thread> findByDiscussion(Discussion discussion, Pageable pageable);
    Page<Thread> findByDiscussionAndParentIsNull(Discussion discussion, Pageable pageable);
}
