package com.finconsgroup.itserr.marketplace.event.bs.client.dto.workspace;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
@Schema(
        name = "Folder create",
        description = "Represents a set of values to create a folder in a workspace")
public class InputFolderCreateDto {

    @Schema(description = "Name of the folder", example = "Biology")
    private String name;

    @Schema(description = "Description of the folder", example = "Containing info about cellular mitosis")
    private String description;

    @Schema(description = "Boolean value indicating if a folder is hidden or not", example = "false")
    private Boolean hidden = false;
}
