package com.finconsgroup.itserr.marketplace.event.bs.validation;

import com.finconsgroup.itserr.marketplace.event.bs.util.DateTimeUtils;
import com.finconsgroup.itserr.marketplace.event.bs.validation.annotation.ValidInputCreateOrUpdateEventDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputEventConductorDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputProgramDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputScheduleDto;
import com.finconsgroup.itserr.marketplace.event.dm.dto.InputUpdateEventDto;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Component
public class InputCreateOrUpdateEventDtoValidator implements ConstraintValidator<ValidInputCreateOrUpdateEventDto, Object> {

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean valid = true;

        switch (value) {
            case null -> {
                return valid;
            }
            case com.finconsgroup.itserr.marketplace.event.dm.dto.InputCreateEventDto inputCreateEventDto ->
                    valid = validateSchedules(context, inputCreateEventDto.getSchedules(), inputCreateEventDto.getEventConductors());
            case InputUpdateEventDto inputUpdateEventDto ->
                    valid = validateSchedules(context, inputUpdateEventDto.getSchedules(), inputUpdateEventDto.getEventConductors());
            default -> {
            }
        }

        return valid;
    }

    private boolean validateSchedules(ConstraintValidatorContext context,
                                      List<InputScheduleDto> schedules,
                                      List<InputEventConductorDto> eventConductors) {
        boolean valid = true;

        LocalDate startDate = null;
        LocalDate endDate = null;

        if (schedules != null) {
            for (int i = 0; i < schedules.size(); i++) {
                InputScheduleDto schedule = schedules.get(i);
                if (schedule == null) {
                    continue;
                }

                startDate = DateTimeUtils.min(startDate, schedule.getStartDate());
                endDate = DateTimeUtils.max(endDate, schedule.getStartDate());

            }

            if (startDate == null) {
                context.buildConstraintViolationWithTemplate("event_bs_event_calculated_start_date_null")
                        .addConstraintViolation();
                valid = false;
            }
            if (endDate == null) {
                context.buildConstraintViolationWithTemplate("event_bs_event_calculated_end_date_null")
                        .addConstraintViolation();
                valid = false;
            }
        }
        return valid;
    }
}
