package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.time.Instant;
import java.util.List;
import java.util.UUID;

/**
 * Output DTO for subscribed participant.
 */
@Schema(name = "OutputSubscribedParticipantDto", description = "DTO representing a subscribed participant in responses")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class OutputSubscribedParticipantDto {

    @Schema(description = "The ID of the subscribed participant", example = "123e4567-e89b-12d3-a456-426614174002")
    private UUID id;

    @Schema(description = "The ID of the event", example = "123e4567-e89b-12d3-a456-426614174002")
    private UUID eventId;

    @Schema(description = "The ID of the subscribed participant user profile", example = "123e4567-e89b-12d3-a456-426614174002")
    private UUID userId;

    @Schema(description = "The creation time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant updateTime;

    @Schema(description = "List of programs, participant has subscribed to")
    List<OutputSubscribedProgramDto> subscribedPrograms;
}
