package com.finconsgroup.itserr.marketplace.event.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import java.util.List;

import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.ENUM_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.LINK_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.LONG_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.event.dm.util.DomainConstants.MEDIUM_TEXT_LENGTH;

/**
 * Input DTO for creating event.
 */
@Schema(name = "InputCreateEventDto", description = "DTO for creating event")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class InputCreateEventDto {

    @Schema(description = "The title of the event", example = "Annual Tech Conference 2025")
    @NotBlank
    @Size(max = MEDIUM_TEXT_LENGTH)
    private String title;

    @Schema(description = "The link for the event", example = "https://meeting.example.com/test123")
    @Size(max = LINK_TEXT_LENGTH)
    private String eventLink;

    @Schema(description = "The type of event", example = "webinar")
    @Size(max = ENUM_FIELD_LENGTH)
    private String eventType;

    @Schema(description = "The content of the event", example = "Join us for the biggest tech conference of the year...")
    @Size(max = LONG_TEXT_LENGTH)
    private String content;

    @Schema(description = "List of tags associated with the event", example = "[\"technology\", \"conference\", \"innovation\"]")
    private List<String> tags;

    @Schema(description = "List of institutional pages")
    private List<InputInstitutionalPageDto> institutionalPages;

    @Schema(description = "The image for the event")
    @Valid
    private InputImageDto image;

    @Schema(description = "The timezone for the event", example = "Europe/Rome")
    @NotBlank
    private String timezone;

    @Schema(description = "The event conductors")
    @Valid
    @NotEmpty
    private List<InputEventConductorDto> eventConductors;

    @Schema(description = "The event schedules")
    @Valid
    @NotEmpty
    private List<InputScheduleDto> schedules;

}
