package com.finconsgroup.itserr.marketplace.favourite.user.bs.enums;

import com.fasterxml.jackson.annotation.JsonValue;

public enum CatalogItemModerationStatus {
    PENDING("pending"),
    APPROVED("approved"),
    REJECTED("rejected");

    private final String value;

    CatalogItemModerationStatus(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public static CatalogItemModerationStatus fromValue(String value) {
        for (CatalogItemModerationStatus status : values()) {
            if (status.value.equals(value)) {
                return status;
            }
        }

        throw new IllegalArgumentException("Unknown catalog item status: " + value);
    }
}
