package com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageCreatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageDeletedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPagePublicationRequestNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.InstitutionalPageUpdatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.JoinRequestNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.JoinRequestStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MemberInvitationNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MemberInvitationStatusChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MembershipChangeNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.MembershipRemovalNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.ParagraphCreatedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.ParagraphDeletedNotificationData;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.data.ParagraphUpdatedNotificationData;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * Local stub implementation of {@link NotificationProducer}.
 * <p>
 * This implementation does not send any real messages but logs the invocation for testing purposes.
 */
@Component
@ConditionalOnProperty(name = "messaging.enabled", havingValue = "false")
@Slf4j
public class LoggerNotificationProducer implements NotificationProducer {

    @Override
    public void publishInstitutionalPageCreatedNotification(MessagingEventDto<InstitutionalPageCreatedNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - CREATED notification for object: {}", message.getId());
    }

    @Override
    public void publishInstitutionalPageUpdatedNotification(MessagingEventDto<InstitutionalPageUpdatedNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - UPDATED notification for object: {}", message.getId());
    }

    @Override
    public void publishInstitutionalPageDeletedNotification(MessagingEventDto<InstitutionalPageDeletedNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - DELETED notification for object: {}", message.getId());
    }

    @Override
    public void publishInstitutionalPageStatusChangeNotification(MessagingEventDto<InstitutionalPageStatusChangeNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - STATUS CHANGE notification for object: {}", message.getId());
    }

    @Override
    public void publishInstitutionalPagePublicationRequestNotification(MessagingEventDto<InstitutionalPagePublicationRequestNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - PUBLICATION REQUEST notification for object: {}", message.getId());
    }

    @Override
    public void publishJoinRequestNotification(MessagingEventDto<JoinRequestNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - JOIN REQUEST notification for object: {}", message.getId());
    }

    @Override
    public void publishJoinRequestDeletedNotification(MessagingEventDto<JoinRequestNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - JOIN REQUEST DELETED notification for object: {}", message.getId());
    }

    @Override
    public void publishJoinRequestStatusChangeNotification(MessagingEventDto<JoinRequestStatusChangeNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - JOIN REQUEST STATUS CHANGE notification for object: {}", message.getId());
    }

    @Override
    public void publishMemberInvitationNotification(MessagingEventDto<MemberInvitationNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - MEMBER INVITATION notification for object: {}", message.getId());
    }

    @Override
    public void publishMemberInvitationDeletedNotification(MessagingEventDto<MemberInvitationNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - MEMBER INVITATION DELETED notification for object: {}", message.getId());
    }

    @Override
    public void publishMemberInvitationStatusChangeNotification(MessagingEventDto<MemberInvitationStatusChangeNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - MEMBER INVITATION STATUS CHANGE notification for object: {}", message.getId());
    }

    @Override
    public void publishMembershipChangeNotification(MessagingEventDto<MembershipChangeNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - MEMBERSHIP CHANGE notification for object: {}", message.getId());
    }

    @Override
    public void publishMembershipRemovalNotification(MessagingEventDto<MembershipRemovalNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - MEMBERSHIP REMOVAL notification for object: {}", message.getId());
    }

    @Override
    public void publishParagraphCreatedNotification(MessagingEventDto<ParagraphCreatedNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - PARAGRAPH CREATED notification for object: {}", message.getId());
    }

    @Override
    public void publishParagraphUpdatedNotification(MessagingEventDto<ParagraphUpdatedNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - PARAGRAPH UPDATED notification for object: {}", message.getId());
    }

    @Override
    public void publishParagraphDeletedNotification(MessagingEventDto<ParagraphDeletedNotificationData> message) {
        log.info("Message dispatch skipped (local profile) - PARAGRAPH DELETED notification for object: {}", message.getId());
    }
}