/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutional_page.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.dto.OutputPageDto;
import com.finconsgroup.itserr.marketplace.core.web.enums.SortDirection;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2AuthenticationException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2FeignClientException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.InstitutionalPageDmClient;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.CreateInstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.InstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.ModerationIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.OutputRequestUpdateDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.client.dm.dto.UpdateInstitutionalPageIPDmDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputModerationStatusDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputRequestUpdateDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.dto.OutputWorkspaceItemDto;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.enums.OperationType;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.exceptions.WP2InvalidImageException;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.InstitutionalPageProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationMessageFactory;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.messaging.NotificationProducer;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.UserProfileRepository;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.repository.WorkspaceRepository;
import com.finconsgroup.itserr.marketplace.institutional_page.bs.service.InstitutionalPageService;
import com.finconsgroup.itserr.messaging.dto.MessagingEventDto;
import feign.FeignException;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultInstitutionalPageService
implements InstitutionalPageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultInstitutionalPageService.class);
    private final InstitutionalPageMapper institutionalPageMapper;
    private final InstitutionalPageDmClient institutionalPageDmClient;
    private final WorkspaceRepository workspaceRepository;
    private final UserProfileRepository userProfileRepository;
    private final NotificationMessageFactory notificationMessageFactory;
    private final NotificationProducer notificationProducer;
    private final InstitutionalPageProducer institutionalPageProducer;

    public OutputPageDto<OutputInstitutionalPageDto> getAllInstitutionalPages(Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        try {
            OutputPageDto institutionalPagesDmDto = this.institutionalPageDmClient.getAllInstitutionalPages(associationsToLoad, pageNumber, pageSize, sort, direction);
            return this.institutionalPageMapper.toOutputPageDto(institutionalPagesDmDto);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public OutputInstitutionalPageDto getInstitutionalPageById(UUID institutionalPageId) {
        try {
            InstitutionalPageIPDmDto institutionalPageDmDto = this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId);
            return this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageDmDto, true);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException((Throwable)e);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public OutputInstitutionalPageDto createInstitutionalPage(InputCreateInstitutionalPageDto institutionalPageDto, MultipartFile imageFile) {
        try {
            if (imageFile != null && !imageFile.isEmpty() && (institutionalPageDto.getImageMetadata() == null || institutionalPageDto.getImageMetadata().getName() == null || institutionalPageDto.getImageMetadata().getName().trim().isEmpty())) {
                throw new WP2InvalidImageException("Image name is required when uploading an image file");
            }
            UUID institutionalPageFolderId = this.workspaceRepository.createInstitutionalPageFolder(institutionalPageDto.getName());
            String imageUrl = null;
            if (imageFile != null && !imageFile.isEmpty()) {
                try {
                    String imageDescription = institutionalPageDto.getImageMetadata().getDescription() != null ? institutionalPageDto.getImageMetadata().getDescription() : "";
                    String internalResourcesPrefix = DefaultInstitutionalPageService.getInternalResourcesPrefix((UUID)institutionalPageFolderId);
                    String imageName = internalResourcesPrefix + institutionalPageDto.getImageMetadata().getName();
                    URI uploadedImageUri = this.workspaceRepository.uploadInstitutionalPageImage(institutionalPageFolderId, imageFile.getInputStream(), imageName, imageDescription);
                    imageUrl = uploadedImageUri.toString();
                }
                catch (IOException e) {
                    log.error("Failed to upload image for institutional page", (Throwable)e);
                    throw new WP2BusinessException("Failed to upload image: " + e.getMessage());
                }
            }
            CreateInstitutionalPageIPDmDto createInstitutionalPageDmDto = this.institutionalPageMapper.toCreateInstitutionalPageDmDto(institutionalPageDto, institutionalPageFolderId, imageUrl);
            InstitutionalPageIPDmDto institutionalPageDmDto = this.institutionalPageDmClient.createInstitutionalPage(createInstitutionalPageDmDto);
            OutputInstitutionalPageDto outputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageDmDto, false);
            MessagingEventDto notificationMessage = this.notificationMessageFactory.createInstitutionalPageCreatedNotification(outputInstitutionalPageDto);
            this.notificationProducer.publishInstitutionalPageCreatedNotification(notificationMessage);
            return outputInstitutionalPageDto;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public OutputInstitutionalPageDto updateInstitutionalPage(UUID institutionalPageId, InputUpdateInstitutionalPageDto institutionalPageDto, MultipartFile imageFile) {
        try {
            InstitutionalPageIPDmDto originalInstitutionalPageDmDto;
            OutputInstitutionalPageDto outputInstitutionalPageDto;
            block16: {
                if (imageFile != null && !imageFile.isEmpty() && (institutionalPageDto.getImageMetadata() == null || institutionalPageDto.getImageMetadata().getName() == null || institutionalPageDto.getImageMetadata().getName().trim().isEmpty())) {
                    throw new WP2InvalidImageException("Image name is required when uploading an image file");
                }
                String finalImageUrl = null;
                if (imageFile != null && !imageFile.isEmpty()) {
                    try {
                        InstitutionalPageIPDmDto originalOrPendingInstitutionalPageDmDto;
                        try {
                            originalOrPendingInstitutionalPageDmDto = this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId);
                        }
                        catch (WP2FeignClientException exception) {
                            if (!exception.getHttpStatus().equals((Object)HttpStatus.NOT_FOUND)) {
                                throw exception;
                            }
                            originalOrPendingInstitutionalPageDmDto = this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId);
                        }
                        UUID institutionalPageFolderId = originalOrPendingInstitutionalPageDmDto.getWorkspaceFolderId();
                        String imageDescription = institutionalPageDto.getImageMetadata().getDescription() != null ? institutionalPageDto.getImageMetadata().getDescription() : "";
                        URI uploadedImageUri = this.workspaceRepository.uploadInstitutionalPageImage(institutionalPageFolderId, imageFile.getInputStream(), institutionalPageDto.getImageMetadata().getName(), imageDescription);
                        finalImageUrl = uploadedImageUri.toString();
                    }
                    catch (IOException e) {
                        log.error("Failed to upload image for institutional page update", (Throwable)e);
                        throw new WP2BusinessException("Failed to upload image: " + e.getMessage());
                    }
                }
                if (institutionalPageDto.getImageUrl() != null) {
                    finalImageUrl = institutionalPageDto.getImageUrl();
                }
                UpdateInstitutionalPageIPDmDto updateInstitutionalPageDmDto = this.institutionalPageMapper.toUpdateInstitutionalPageDmDto(institutionalPageDto, finalImageUrl);
                if (updateInstitutionalPageDmDto.getMaintainer() != null) {
                    this.userProfileRepository.getMemberProfilesOrThrow(List.of(updateInstitutionalPageDmDto.getMaintainer())).getFirst();
                }
                InstitutionalPageIPDmDto institutionalPageDmDto = this.institutionalPageDmClient.updateInstitutionalPage(institutionalPageId, updateInstitutionalPageDmDto);
                outputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageDmDto, true);
                MessagingEventDto notificationMessage = this.notificationMessageFactory.createInstitutionalPageUpdatedNotification(outputInstitutionalPageDto);
                this.notificationProducer.publishInstitutionalPageUpdatedNotification(notificationMessage);
                originalInstitutionalPageDmDto = null;
                try {
                    originalInstitutionalPageDmDto = this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId);
                }
                catch (WP2FeignClientException exception) {
                    if (exception.getHttpStatus().equals((Object)HttpStatus.NOT_FOUND)) break block16;
                    throw exception;
                }
            }
            if (originalInstitutionalPageDmDto != null) {
                OutputInstitutionalPageDto originalOutputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(originalInstitutionalPageDmDto, true);
                this.institutionalPageProducer.publishUpdateEvent(originalOutputInstitutionalPageDto);
            }
            return outputInstitutionalPageDto;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NonNull
    public OutputPageDto<OutputInstitutionalPageDto> search(@NonNull InputSearchForMemberInstitutionalPageDto inputSearchForMemberInstitutionalPageDto, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        OutputPageDto institutionalPagesDmDto = this.institutionalPageDmClient.search(inputSearchForMemberInstitutionalPageDto, associationsToLoad, pageNumber, pageSize, sort, direction);
        return this.institutionalPageMapper.toOutputPageDto(institutionalPagesDmDto);
    }

    public void deleteInstitutionalPage(UUID institutionalPageId) {
        try {
            InstitutionalPageIPDmDto institutionalPageIPDmDto = this.institutionalPageDmClient.deleteInstitutionalPage(institutionalPageId);
            if (this.institutionalPageDmClient.isAdmin().booleanValue()) {
                InputModerationStatusDto inputModerationStatusDto = InputModerationStatusDto.builder().approved(Boolean.valueOf(true)).message("").build();
                ModerationIPDmDto moderationIPDmDto = ModerationIPDmDto.builder().institutionalPage(institutionalPageIPDmDto).operationType(OperationType.DELETE).build();
                MessagingEventDto notificationMessage = this.notificationMessageFactory.createInstitutionalPageStatusChangeNotification(inputModerationStatusDto, moderationIPDmDto);
                this.notificationProducer.publishInstitutionalPageStatusChangeNotification(notificationMessage);
                OutputInstitutionalPageDto institutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageIPDmDto, true);
                this.institutionalPageProducer.publishDeleteEvent(institutionalPageDto);
            } else {
                InstitutionalPageIPDmDto originalInstitutionalPageDmDto = this.institutionalPageDmClient.getInstitutionalPageById(institutionalPageId);
                OutputInstitutionalPageDto originalOutputInstitutionalPageDto = this.institutionalPageMapper.toOutputInstitutionalPageDto(originalInstitutionalPageDmDto, true);
                this.institutionalPageProducer.publishUpdateEvent(originalOutputInstitutionalPageDto);
                MessagingEventDto notificationMessage = this.notificationMessageFactory.createInstitutionalPageDeletedNotification(institutionalPageIPDmDto);
                this.notificationProducer.publishInstitutionalPageDeletedNotification(notificationMessage);
            }
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NonNull
    public OutputPageDto<OutputInstitutionalPageDto> findInstitutionalPagesHierarchyByRootId(@NonNull UUID rootInstitutionalPageId, Set<String> associationsToLoad, int pageNumber, int pageSize, String sort, SortDirection direction) {
        try {
            OutputPageDto institutionalPagesDmDto = this.institutionalPageDmClient.findInstitutionalPagesHierarchyByRootId(rootInstitutionalPageId, associationsToLoad, pageNumber, pageSize, sort, direction);
            return institutionalPagesDmDto.map(institutionalPageDmDto -> this.institutionalPageMapper.toOutputInstitutionalPageDto(institutionalPageDmDto, true));
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(rootInstitutionalPageId);
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public List<OutputWorkspaceItemDto> retrieveFolderContent(UUID institutionalPageId, int pageNumber, int pageSize) {
        try {
            UUID folderId = this.getInstitutionalPageById(institutionalPageId).getWorkspaceFolderId();
            String internalResourcesPrefix = DefaultInstitutionalPageService.getInternalResourcesPrefix((UUID)folderId);
            return this.workspaceRepository.getWorkspaceChildrenByFolderId(folderId, Integer.valueOf(pageNumber), Integer.valueOf(pageSize)).stream().filter(workspaceBsDto -> !workspaceBsDto.getName().startsWith(internalResourcesPrefix)).map(arg_0 -> ((InstitutionalPageMapper)this.institutionalPageMapper).toOutputWorkspaceItemDto(arg_0)).toList();
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    @NonNull
    public OutputRequestUpdateDto requestUpdateInstitutionalPageById(@NonNull UUID institutionalPageId) {
        try {
            OutputRequestUpdateDmDto outputRequestUpdateDmDto = this.institutionalPageDmClient.requestUpdateInstitutionalPageById(institutionalPageId);
            OutputRequestUpdateDto outputRequestUpdateDto = this.institutionalPageMapper.toOutputRequestUpdateDto(outputRequestUpdateDmDto);
            return outputRequestUpdateDto;
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    public void cancelUpdateInstitutionalPageById(@NonNull UUID institutionalPageId) {
        try {
            this.institutionalPageDmClient.cancelUpdateInstitutionalPageById(institutionalPageId);
        }
        catch (FeignException.Unauthorized e) {
            throw new WP2AuthenticationException((Throwable)e);
        }
        catch (FeignException.NotFound e) {
            throw new WP2ResourceNotFoundException(e.getMessage());
        }
        catch (FeignException e) {
            throw new WP2BusinessException((Throwable)e);
        }
    }

    private static String getInternalResourcesPrefix(UUID institutionalPageFolderId) {
        return Integer.toHexString(institutionalPageFolderId.hashCode()) + "_";
    }

    @Generated
    public DefaultInstitutionalPageService(InstitutionalPageMapper institutionalPageMapper, InstitutionalPageDmClient institutionalPageDmClient, WorkspaceRepository workspaceRepository, UserProfileRepository userProfileRepository, NotificationMessageFactory notificationMessageFactory, NotificationProducer notificationProducer, InstitutionalPageProducer institutionalPageProducer) {
        this.institutionalPageMapper = institutionalPageMapper;
        this.institutionalPageDmClient = institutionalPageDmClient;
        this.workspaceRepository = workspaceRepository;
        this.userProfileRepository = userProfileRepository;
        this.notificationMessageFactory = notificationMessageFactory;
        this.notificationProducer = notificationProducer;
        this.institutionalPageProducer = institutionalPageProducer;
    }
}

