package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;
import java.util.UUID;

import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.MAX_MEDIUM_TEXT_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;
import static com.finconsgroup.itserr.marketplace.institutionalpage.dm.util.Constants.VALIDATION_ERROR_REQUIRED_FIELD;


/**
 * Input DTO for inviting users to join the InstitutionalPage as members.
 */
@Schema(name = "InputInviteMembersDto", description = "Input DTO for inviting users to join the InstitutionalPage as members")
@Data
@Builder
@AllArgsConstructor
public class InputInviteMembersDto {

    @Schema(
            description = "IDs of users to be invited to contribute to the institutional page",
            example = "[\"33333333-aaaa-1111-0000-000000000000\",\"33333333-aaaa-2222-0000-000000000000\"]"
    )
    @Size(min = 1, message = VALIDATION_ERROR_FIELD_LENGTH)
    private List<@NotNull(message = VALIDATION_ERROR_REQUIRED_FIELD) UUID> userIds;

    @Schema(description = "Indicate if the user should be added as wp leader", example = "false")
    @NotNull
    private Boolean wpLeader;

    @Schema(description = "The invitation message", example = "Please join as a member")
    @Size(max = MAX_MEDIUM_TEXT_LENGTH, message = VALIDATION_ERROR_FIELD_LENGTH)
    private String message;
}
