package com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.util.List;

/**
 * Output DTO for pending member join requests and invitations.
 */
@Schema(name = "OutputPendingMemberRequestsDto", description = "Output DTO for pending member join requests and invitations")
@Data
@Builder
@AllArgsConstructor
public class OutputPendingMemberRequestsDto {

    @Schema(description = "List of pending invitations")
    private List<OutputPendingMemberRequestDto> invitations;

    @Schema(description = "List of pending join requests")
    private List<OutputPendingMemberRequestDto> joinRequests;

}