package com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;

import java.util.List;
import java.util.UUID;

public class MemberRequestsAlreadyExistException extends WP2ResourceNotFoundException {

    public static final String EXCEPTION_MESSAGE =
            "Pending requests already exist for institutionalPage id '%s' and user ids '%s'";

    public MemberRequestsAlreadyExistException(UUID institutionalPageId, List<UUID> userIds) {
        super(EXCEPTION_MESSAGE.formatted(institutionalPageId, userIds));
    }
}
