package com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedInstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedMemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedMemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ArchivedParagraphEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberRequestEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.ParagraphEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.MemberRequestStatus;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.List;

@Mapper(config = MapperConfiguration.class)
public interface ArchivedEntityMapper {

    @Mapping(target = "archivalTime", ignore = true)
    ArchivedInstitutionalPageEntity toArchiveEntity(InstitutionalPageEntity src);

    @Mapping(target = "archivalTime", ignore = true)
    @Mapping(target = "institutionalPage", ignore = true)
    @Mapping(target = "institutionalPageId", ignore = true)
    ArchivedMemberEntity toArchiveEntity(MemberEntity src);

    @Mapping(target = "archivalTime", ignore = true)
    @Mapping(target = "institutionalPage", ignore = true)
    @Mapping(target = "institutionalPageId", ignore = true)
    ArchivedParagraphEntity toArchiveEntity(ParagraphEntity src);

    @Mapping(target = "requestStatus", source = "requestStatus")
    @Mapping(target = "message", source = "message")
    @Mapping(target = "archivalTime", ignore = true)
    ArchivedMemberRequestEntity toArchiveEntity(
            MemberRequestEntity src,
            MemberRequestStatus requestStatus,
            String message
    );

    @Mapping(target = "requestStatus", source = "requestStatus")
    @Mapping(target = "archivalTime", ignore = true)
    ArchivedMemberRequestEntity toArchiveEntity(
            MemberRequestEntity src,
            MemberRequestStatus requestStatus
    );

    default List<ArchivedMemberRequestEntity> toArchiveEntityList(
            List<MemberRequestEntity> src,
            MemberRequestStatus requestStatus,
            String message
    ) {
        return src.stream()
                .map(item -> toArchiveEntity(item, requestStatus, message))
                .toList();
    }

    default List<ArchivedMemberRequestEntity> toArchiveEntityList(
            List<MemberRequestEntity> src,
            MemberRequestStatus requestStatus
    ) {
        return src.stream()
                .map(item -> toArchiveEntity(item, requestStatus))
                .toList();
    }

}
