/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.api;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputInviteMembersDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPInvitationRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchMembershipDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputRemoveMembershipDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSubmitJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputPendingMemberRequestsDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Member", description="The Member API: It provides endpoints for join requests, invitations, accept/reject of join-requests/invitations, and promotion to WP Leader")
@SecurityRequirement(name="BearerAuth")
public interface MemberApi {
    @Operation(summary="Indicates whether the user has IP Moderator role", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/institutional-page/admin"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Boolean hasIPModerateRole();

    @Operation(summary="Retrieves all pending member join requests and invitations for a specific InstitutionalPage (WP Leader)", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputPendingMemberRequestsDto findPendingMemberRequestsForInstitutionalPage(@PathVariable(value="institutionalPageId") UUID var1);

    @Operation(summary="Retrieves all pending member join requests and invitations related to the authenticated user", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/institutional-page/institutional-pages/members/requests"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputPendingMemberRequestsDto findPendingMemberRequestsForUser();

    @Operation(summary="Invites users to join the specified InstitutionalPage as members (WP Leader)", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/invitations"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputPendingMemberRequestsDto inviteMembers(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody InputInviteMembersDto var2);

    @Operation(summary="Cancels an invitation for a specific user to join an InstitutionalPage (WP Leader)", responses={@ApiResponse(responseCode="200", description="OK")})
    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/invitations/{invitedUserId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputPendingMemberRequestsDto cancelInvitation(@PathVariable(value="institutionalPageId") UUID var1, @PathVariable(value="invitedUserId") UUID var2);

    @Operation(summary="Accepts/Rejects an invitation to join an InstitutionalPage", responses={@ApiResponse(responseCode="200", description="OK")})
    @PatchMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/invitations"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputPendingMemberRequestsDto acceptOrRejectInvitation(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody InputPatchIPInvitationRequestDto var2);

    @Operation(summary="Updates membership of members to WP Leader/Member for an InstitutionalPage (WP Leader)", responses={@ApiResponse(responseCode="200", description="OK")})
    @PatchMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/membership"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto patchMembershipOfUsersForInstitutionalPage(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody InputPatchMembershipDto var2);

    @Operation(summary="Remove membership of users for an InstitutionalPage", responses={@ApiResponse(responseCode="200", description="OK")})
    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/membership"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto removeMembershipOfUsersForInstitutionalPage(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody InputRemoveMembershipDto var2);

    @Operation(summary="Submits a join request for the authenticated user to join an InstitutionalPage", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/join"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputPendingMemberRequestsDto submitJoinRequest(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody InputSubmitJoinRequestDto var2);

    @Operation(summary="Cancels a join request previously submitted by the authenticated user", responses={@ApiResponse(responseCode="200", description="OK")})
    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/join"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputPendingMemberRequestsDto cancelJoinRequest(@PathVariable(value="institutionalPageId") UUID var1);

    @Operation(summary="Accepts/Rejects join requests to an institutional page (WP Leader)", responses={@ApiResponse(responseCode="200", description="OK")})
    @PatchMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/members/requests/join"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputPendingMemberRequestsDto acceptOrRejectJoinRequests(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody InputPatchIPJoinRequestDto var2);

    @Operation(summary="Retrieves paginated list of all users belonging to the hierarchy of a given root InstitutionalPage (WP Leader).", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/institutional-page/institutional-pages/{rootInstitutionalPageId}/members/hierarchy"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputMembersInHierarchyDto> findAllUsersInHierarchy(@PathVariable(value="rootInstitutionalPageId") UUID var1, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var2, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var3);
}

