/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.component;

import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.AssociationLoader;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.InstitutionalPageHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchPendingInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageForMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputRelatedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.MemberEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.InstitutionalPageMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.MemberMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.mapper.ParagraphMapper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchForMemberInstitutionalPageModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchInstitutionalPageModel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DtoBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DtoBuilder.class);
    private final InstitutionalPageMapper institutionalPageMapper;
    private final ParagraphMapper paragraphMapper;
    private final MemberMapper memberMapper;
    private final AssociationLoader associationLoader;

    public OutputInstitutionalPageDto mapEntityToDto(UUID userId, InstitutionalPageEntity institutionalPage) {
        return (OutputInstitutionalPageDto)this.mapEntitiesToDtos(userId, List.of(institutionalPage)).stream().findFirst().orElseThrow(() -> new WP2BusinessException("error during mapEntitiesToDtos: not output dto returned"));
    }

    public List<OutputInstitutionalPageDto> mapEntitiesToDtos(UUID userId, List<InstitutionalPageEntity> institutionalPages) {
        PageImpl page = new PageImpl(institutionalPages);
        return this.mapEntitiesToDtos(userId, (Page)page, Set.of("all")).getContent();
    }

    public Page<OutputInstitutionalPageDto> mapEntitiesToDtos(UUID userId, Page<InstitutionalPageEntity> institutionalPageEntityPage, Set<String> associationsToLoad) {
        AssociationLoader.LoadedAssociations loadedAssociations = this.associationLoader.loadAssociations(institutionalPageEntityPage, associationsToLoad);
        return institutionalPageEntityPage.map(institutionalPage -> {
            AssociationLoader.Associations associations = this.associationLoader.buildAssociations(institutionalPage, associationsToLoad, loadedAssociations);
            return this.mapEntityToDtoWithAssociations(userId, institutionalPage, associations);
        });
    }

    private OutputInstitutionalPageDto mapEntityToDtoWithAssociations(UUID userId, InstitutionalPageEntity institutionalPageEntity, AssociationLoader.Associations associations) {
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.institutionalPageMapper.toDto(institutionalPageEntity);
        outputInstitutionalPageDto.setRootInstitutionalPageName(associations.rootInstitutionalPageName);
        outputInstitutionalPageDto.setParentInstitutionalPage(this.toRelatedInstitutionalPageDto(userId, associations.parentInstitutionalPage));
        outputInstitutionalPageDto.setChildInstitutionalPages(((List)Optional.ofNullable(associations.childInstitutionalPages).orElse(new LinkedList())).stream().map(institutionalPageWithMembers -> this.toRelatedInstitutionalPageDto(userId, institutionalPageWithMembers)).toList());
        outputInstitutionalPageDto.setParagraphs(((List)Optional.ofNullable(associations.paragraphs).orElse(new LinkedList())).stream().map(paragraph -> this.paragraphMapper.toDto(paragraph)).toList());
        outputInstitutionalPageDto.setWpLeads(this.memberMapper.toMemberIds((List)Optional.ofNullable(associations.wpLeads).orElse(new LinkedList())));
        outputInstitutionalPageDto.setMembers(this.memberMapper.toMemberIds((List)Optional.ofNullable(associations.members).orElse(new LinkedList())));
        outputInstitutionalPageDto.setHasUpdatedVersion(Boolean.valueOf(institutionalPageEntity.getUpdatedInstitutionalPageId() != null));
        outputInstitutionalPageDto.setId(InstitutionalPageHelper.getOriginalInstitutionalPageId((InstitutionalPageEntity)institutionalPageEntity));
        outputInstitutionalPageDto.setRootInstitutionalPageId(InstitutionalPageHelper.getRootInstitutionalPageId((InstitutionalPageEntity)institutionalPageEntity));
        return outputInstitutionalPageDto;
    }

    public SearchForMemberInstitutionalPageModel toFilters(InputSearchForMemberInstitutionalPageDto inputSearchForMemberInstitutionalPageDto) {
        return this.institutionalPageMapper.toModel(inputSearchForMemberInstitutionalPageDto);
    }

    public SearchInstitutionalPageModel toFilters(InputSearchPublishedInstitutionalPageDto inputSearchPublishedInstitutionalPageDto) {
        SearchInstitutionalPageModel searchInstitutionalPageModel = this.institutionalPageMapper.toModel(inputSearchPublishedInstitutionalPageDto);
        searchInstitutionalPageModel.setPublished(Boolean.valueOf(true));
        return searchInstitutionalPageModel;
    }

    public SearchInstitutionalPageModel toFilters(InputSearchPendingInstitutionalPageDto inputSearchPendingInstitutionalPageDto) {
        return this.institutionalPageMapper.toModel(inputSearchPendingInstitutionalPageDto);
    }

    public SearchForMemberInstitutionalPageModel toFiltersForMember(InputSearchPendingInstitutionalPageDto inputSearchPendingInstitutionalPageDto) {
        SearchForMemberInstitutionalPageModel searchForMemberInstitutionalPageModel = this.institutionalPageMapper.toModelForMember(inputSearchPendingInstitutionalPageDto);
        searchForMemberInstitutionalPageModel.setWpLeaderOnly(Boolean.valueOf(false));
        searchForMemberInstitutionalPageModel.setIncludePublishedAndNotMember(Boolean.valueOf(false));
        if (inputSearchPendingInstitutionalPageDto.getPublished() == null) {
            searchForMemberInstitutionalPageModel.setIncludePrivateAndMember(Boolean.valueOf(true));
            searchForMemberInstitutionalPageModel.setIncludePublishedAndMember(Boolean.valueOf(true));
        } else if (Boolean.TRUE.equals(inputSearchPendingInstitutionalPageDto.getPublished())) {
            searchForMemberInstitutionalPageModel.setIncludePrivateAndMember(Boolean.valueOf(false));
            searchForMemberInstitutionalPageModel.setIncludePublishedAndMember(Boolean.valueOf(true));
        } else {
            searchForMemberInstitutionalPageModel.setIncludePrivateAndMember(Boolean.valueOf(true));
            searchForMemberInstitutionalPageModel.setIncludePublishedAndMember(Boolean.valueOf(false));
        }
        return searchForMemberInstitutionalPageModel;
    }

    public static OutputMembersInHierarchyDto toMembersInHierarchyDto(UUID rootInstitutionalPageId, Map.Entry<UUID, List<MemberEntity>> entry, Map<UUID, OutputInstitutionalPageDto> institutionPageIdToDtoMap) {
        OutputInstitutionalPageDto rootInstitutionalPage = institutionPageIdToDtoMap.get(rootInstitutionalPageId);
        List<OutputInstitutionalPageForMembersInHierarchyDto> institutionalPages = entry.getValue().stream().map(member -> DtoBuilder.getOutputInstitutionalPageForMembersInHierarchyDto((MemberEntity)member, (Map)institutionPageIdToDtoMap)).toList();
        return OutputMembersInHierarchyDto.builder().userId(entry.getKey()).rootInstitutionalPage(rootInstitutionalPage).institutionalPages(institutionalPages).build();
    }

    private OutputRelatedInstitutionalPageDto toRelatedInstitutionalPageDto(UUID userId, AssociationLoader.InstitutionalPageWithMembers institutionalPageWithMembers) {
        if (institutionalPageWithMembers == null) {
            return null;
        }
        boolean isMember = this.isMemberOfRelatedInstitutionalPage(userId, institutionalPageWithMembers);
        return this.institutionalPageMapper.toRelatedInstitutionalPageDto(institutionalPageWithMembers.institutionalPage, isMember);
    }

    private boolean isMemberOfRelatedInstitutionalPage(UUID userId, AssociationLoader.InstitutionalPageWithMembers institutionalPageWithMembersEntity) {
        LinkedList memberEntities = new LinkedList();
        memberEntities.addAll(Optional.ofNullable(institutionalPageWithMembersEntity.getWpLeads()).orElse(new LinkedList()));
        memberEntities.addAll(Optional.ofNullable(institutionalPageWithMembersEntity.getMembers()).orElse(new LinkedList()));
        HashSet memberIds = new HashSet(this.memberMapper.toMemberIds(memberEntities));
        return memberIds.contains(userId);
    }

    private static OutputInstitutionalPageForMembersInHierarchyDto getOutputInstitutionalPageForMembersInHierarchyDto(MemberEntity member, Map<UUID, OutputInstitutionalPageDto> institutionPageIdToDtoMap) {
        OutputInstitutionalPageDto outputInstitutionalPageDto = institutionPageIdToDtoMap.get(member.getInstitutionalPageId());
        return OutputInstitutionalPageForMembersInHierarchyDto.builder().institutionalPage(outputInstitutionalPageDto).wpLead(member.isWpLead()).build();
    }

    @Generated
    public DtoBuilder(InstitutionalPageMapper institutionalPageMapper, ParagraphMapper paragraphMapper, MemberMapper memberMapper, AssociationLoader associationLoader) {
        this.institutionalPageMapper = institutionalPageMapper;
        this.paragraphMapper = paragraphMapper;
        this.memberMapper = memberMapper;
        this.associationLoader = associationLoader;
    }
}

