/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.api.MemberApi;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputInviteMembersDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPInvitationRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchMembershipDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputRemoveMembershipDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSubmitJoinRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputMembersInHierarchyDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputPendingMemberRequestsDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.MemberService;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MemberController
implements MemberApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MemberController.class);
    private final MemberService memberService;

    public Boolean hasIPModerateRole() {
        log.debug("GET /api/v1/dm/institutional-page/admin");
        return this.memberService.hasIPModerateRole();
    }

    public OutputPendingMemberRequestsDto findPendingMemberRequestsForInstitutionalPage(UUID institutionalPageId) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/{}/members/requests", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.findPendingMemberRequestsForInstitutionalPage(userId, institutionalPageId);
    }

    public OutputPendingMemberRequestsDto findPendingMemberRequestsForUser() {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/members/requests");
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.findPendingMemberRequestsForUser(userId);
    }

    public OutputPendingMemberRequestsDto inviteMembers(UUID institutionalPageId, InputInviteMembersDto inputInviteMembersDto) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages/{}/members/requests/invitations, inputInviteMembersDto: {}", (Object)institutionalPageId, (Object)inputInviteMembersDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.inviteMembers(userId, institutionalPageId, inputInviteMembersDto);
    }

    public OutputPendingMemberRequestsDto cancelInvitation(UUID institutionalPageId, UUID invitedUserId) {
        log.debug("DELETE /api/v1/dm/institutional-page/institutional-pages/{}/members/requests/invitations/{}", (Object)institutionalPageId, (Object)invitedUserId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.cancelInvitation(userId, institutionalPageId, invitedUserId);
    }

    public OutputPendingMemberRequestsDto acceptOrRejectInvitation(UUID institutionalPageId, InputPatchIPInvitationRequestDto inputPatchIPInvitationRequestDto) {
        log.debug("PATCH /api/v1/dm/institutional-page/institutional-pages/{}/members/requests/invitations, inputPatchIPInvitationRequestDto: {}", (Object)institutionalPageId, (Object)inputPatchIPInvitationRequestDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.acceptOrRejectInvitation(userId, institutionalPageId, inputPatchIPInvitationRequestDto);
    }

    public OutputInstitutionalPageDto patchMembershipOfUsersForInstitutionalPage(UUID institutionalPageId, InputPatchMembershipDto inputPatchMembershipDto) {
        log.debug("PATCH /api/v1/dm/institutional-page/institutional-pages/{}/members/membership, inputPatchMembershipDto: {}", (Object)institutionalPageId, (Object)inputPatchMembershipDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.patchMembershipOfUsersForInstitutionalPage(userId, institutionalPageId, inputPatchMembershipDto);
    }

    public OutputInstitutionalPageDto removeMembershipOfUsersForInstitutionalPage(UUID institutionalPageId, InputRemoveMembershipDto inputRemoveMembershipDto) {
        log.debug("DELETE /api/v1/dm/institutional-page/institutional-pages/{}/members/membership, inputRemoveMembershipDto: {}", (Object)institutionalPageId, (Object)inputRemoveMembershipDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.removeMembershipOfUsersForInstitutionalPage(userId, institutionalPageId, inputRemoveMembershipDto);
    }

    public OutputPendingMemberRequestsDto submitJoinRequest(UUID institutionalPageId, InputSubmitJoinRequestDto inputSubmitJoinRequestDto) {
        log.debug("POST /api/v1/dm/institutional-page/institutional-pages/{}/members/requests/join, inputSubmitJoinRequestDto: {}", (Object)institutionalPageId, (Object)inputSubmitJoinRequestDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.submitJoinRequest(userId, institutionalPageId, inputSubmitJoinRequestDto);
    }

    public OutputPendingMemberRequestsDto cancelJoinRequest(UUID institutionalPageId) {
        log.debug("DELETE /api/v1/dm/institutional-page/institutional-pages/{}/members/requests/join", (Object)institutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.cancelJoinRequest(userId, institutionalPageId);
    }

    public OutputPendingMemberRequestsDto acceptOrRejectJoinRequests(UUID institutionalPageId, InputPatchIPJoinRequestDto inputPatchIPJoinRequestDto) {
        log.debug("PATCH /api/v1/dm/institutional-page/institutional-pages/{}/members/requests/join, inputPatchIPJoinRequestDto: {}", (Object)institutionalPageId, (Object)inputPatchIPJoinRequestDto);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        return this.memberService.acceptOrRejectJoinRequests(userId, institutionalPageId, inputPatchIPJoinRequestDto);
    }

    public Page<OutputMembersInHierarchyDto> findAllUsersInHierarchy(UUID rootInstitutionalPageId, int pageNumber, int pageSize) {
        log.debug("GET /api/v1/dm/institutional-page/institutional-pages/{}/members/hierarchy", (Object)rootInstitutionalPageId);
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize);
        return this.memberService.findAllUsersInHierarchy(userId, (Pageable)pageable, rootInstitutionalPageId);
    }

    @Generated
    public MemberController(MemberService memberService) {
        this.memberService = memberService;
    }
}

