/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.impl;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.ArchiveHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.DtoBuilder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.EntityBuilder;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.InstitutionalPageHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.InstitutionalPageModerationHandler;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.component.MemberHelper;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputPatchIPModerationRequestDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchPendingInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchPublishedInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputModerationDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputRequestUpdateDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.entity.InstitutionalPageEntity;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationOperationType;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.ModerationStatus;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.InstitutionalPageHasChildrenException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.InvalidModerationStatusException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.NotInstitutionalPageWPLeaderException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.exception.UpdateLockedException;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchForMemberInstitutionalPageModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.model.SearchInstitutionalPageModel;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.service.InstitutionalPageService;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DefaultInstitutionalPageService
implements InstitutionalPageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultInstitutionalPageService.class);
    private final InstitutionalPageModerationHandler institutionalPageModerationHandler;
    private final InstitutionalPageHelper institutionalPageHelper;
    private final MemberHelper memberHelper;
    private final ArchiveHelper archiveHelper;
    private final EntityBuilder entityBuilder;
    private final DtoBuilder dtoBuilder;

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto createInstitutionalPage(@NonNull UUID userId, @NonNull InputCreateInstitutionalPageDto inputCreateInstitutionalPageDto) {
        UUID parentInstitutionalPageId = inputCreateInstitutionalPageDto.getParentInstitutionalPageId();
        InstitutionalPageEntity parentInstitutionalPageEntity = null;
        if (parentInstitutionalPageId != null) {
            this.memberHelper.verifyWpLeaderOrThrow(userId, parentInstitutionalPageId);
            parentInstitutionalPageEntity = this.institutionalPageHelper.retrieveOriginalForMemberById(userId, parentInstitutionalPageId);
            if (!parentInstitutionalPageEntity.getModerationStatus().equals((Object)ModerationStatus.APPROVED)) {
                throw new InvalidModerationStatusException(parentInstitutionalPageId, parentInstitutionalPageEntity.getModerationStatus());
            }
        }
        InstitutionalPageEntity institutionalPageEntity = this.entityBuilder.buildInstitutionalPage(userId, parentInstitutionalPageEntity, inputCreateInstitutionalPageDto);
        institutionalPageEntity = this.institutionalPageModerationHandler.create(institutionalPageEntity);
        InstitutionalPageEntity savedInstitutionalPageEntity = this.institutionalPageHelper.save(userId, institutionalPageEntity);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPageEntity);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputInstitutionalPageDto> findAllInstitutionalPages(@NonNull UUID userId, @NonNull Set<String> associationsToLoad, @NonNull Pageable pageable) {
        Page institutionalPageEntityPage = this.institutionalPageHelper.retrieveAllApprovedForMember(userId, pageable);
        return this.dtoBuilder.mapEntitiesToDtos(userId, institutionalPageEntityPage, associationsToLoad);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputInstitutionalPageDto> searchInstitutionalPages(@NonNull UUID userId, @NonNull Set<String> associationsToLoad, @NonNull Pageable pageable, @NonNull InputSearchForMemberInstitutionalPageDto inputSearchForMemberInstitutionalPageDto) {
        SearchForMemberInstitutionalPageModel searchInstitutionalPageModel = this.dtoBuilder.toFilters(inputSearchForMemberInstitutionalPageDto);
        Page institutionalPageEntityPage = this.institutionalPageHelper.retrieveAllApprovedForMemberWithFilter(userId, pageable, searchInstitutionalPageModel);
        return this.dtoBuilder.mapEntitiesToDtos(userId, institutionalPageEntityPage, associationsToLoad);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputInstitutionalPageDto findInstitutionalPageById(@NonNull UUID userId, @NonNull UUID institutionalPageId) {
        InstitutionalPageEntity institutionalPageEntity = this.institutionalPageHelper.retrieveApprovedForMemberById(userId, institutionalPageId);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, institutionalPageEntity);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto updateInstitutionalPageById(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull InputUpdateInstitutionalPageDto inputUpdateInstitutionalPageDto) {
        boolean maintainerIsWPLeader;
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        InstitutionalPageEntity retrievedInstitutionalPageEntity = this.institutionalPageHelper.retrieveLatestForMemberById(userId, institutionalPageId);
        UUID maintainer = inputUpdateInstitutionalPageDto.getMaintainer();
        if (maintainer != null && !(maintainerIsWPLeader = this.memberHelper.isWpLeader(maintainer, retrievedInstitutionalPageEntity))) {
            throw new NotInstitutionalPageWPLeaderException(userId, institutionalPageId);
        }
        InstitutionalPageEntity institutionalPageEntity = this.institutionalPageModerationHandler.update(userId, institutionalPageId, retrievedInstitutionalPageEntity);
        this.entityBuilder.updateEntity(institutionalPageEntity, inputUpdateInstitutionalPageDto);
        UUID updateLockedBy = institutionalPageEntity.getUpdateLockedBy();
        if (updateLockedBy != null && !updateLockedBy.equals(userId)) {
            throw new UpdateLockedException(institutionalPageId, updateLockedBy);
        }
        institutionalPageEntity.setUpdateLockedBy(null);
        InstitutionalPageEntity savedInstitutionalPageEntity = this.institutionalPageHelper.save(userId, institutionalPageEntity);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPageEntity);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto deleteInstitutionalPageById(@NonNull UUID userId, @NonNull UUID institutionalPageId) {
        OutputInstitutionalPageDto outputInstitutionalPageDto;
        if (this.memberHelper.hasIPModerateRole()) {
            InstitutionalPageEntity retrievedInstitutionalPageEntity = this.institutionalPageHelper.retrieveLatestById(institutionalPageId);
            this.verifyNoChildrenOrThrow(institutionalPageId, retrievedInstitutionalPageEntity);
            InstitutionalPageEntity institutionalPageEntity = this.institutionalPageModerationHandler.prepareForImmediateDeletion(retrievedInstitutionalPageEntity);
            outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, institutionalPageEntity);
            this.archiveHelper.persistArchivedCopy(institutionalPageEntity);
            this.institutionalPageHelper.delete(institutionalPageEntity);
        } else {
            this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
            InstitutionalPageEntity retrievedInstitutionalPageEntity = this.institutionalPageHelper.retrieveLatestForMemberById(userId, institutionalPageId);
            this.verifyNoChildrenOrThrow(institutionalPageId, retrievedInstitutionalPageEntity);
            InstitutionalPageEntity institutionalPageEntity = this.institutionalPageModerationHandler.update(userId, institutionalPageId, retrievedInstitutionalPageEntity);
            institutionalPageEntity.setToDelete(true);
            UUID updateLockedBy = institutionalPageEntity.getUpdateLockedBy();
            if (updateLockedBy != null && !updateLockedBy.equals(userId)) {
                throw new UpdateLockedException(institutionalPageId, updateLockedBy);
            }
            institutionalPageEntity.setUpdateLockedBy(null);
            InstitutionalPageEntity updatedInstitutionalPageEntity = this.institutionalPageHelper.save(userId, institutionalPageEntity);
            outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, updatedInstitutionalPageEntity);
        }
        return outputInstitutionalPageDto;
    }

    private void verifyNoChildrenOrThrow(UUID institutionalPageId, InstitutionalPageEntity retrievedInstitutionalPageEntity) {
        Set childInstitutionalPageIds = this.institutionalPageHelper.retrieveOriginalChildInstitutionalPages(retrievedInstitutionalPageEntity).stream().map(childInstitutionalPageEntity -> childInstitutionalPageEntity.getId()).collect(Collectors.toSet());
        if (!childInstitutionalPageIds.isEmpty()) {
            throw new InstitutionalPageHasChildrenException(institutionalPageId, childInstitutionalPageIds);
        }
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputInstitutionalPageDto> findInstitutionalPagesHierarchyByRootId(@NonNull UUID userId, @NonNull Set<String> associationsToLoad, @NonNull Pageable pageable, @NonNull UUID rootInstitutionalPageId) {
        Page institutionalPageEntityPage = this.institutionalPageHelper.retrieveAllApprovedHierarchyForMemberByRootId(userId, pageable, rootInstitutionalPageId);
        return this.dtoBuilder.mapEntitiesToDtos(userId, institutionalPageEntityPage, associationsToLoad);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto updateFolderId(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull UUID newFolderId) {
        InstitutionalPageEntity latestInstitutionalPageEntity = this.institutionalPageHelper.retrieveLatestById(institutionalPageId);
        latestInstitutionalPageEntity.setWorkspaceFolderId(newFolderId);
        InstitutionalPageEntity savedInstitutionalPageEntity = this.institutionalPageHelper.save(userId, latestInstitutionalPageEntity);
        if (latestInstitutionalPageEntity.getOriginalInstitutionalPageId() != null) {
            InstitutionalPageEntity originalInstitutionalPageEntity = this.institutionalPageHelper.retrieveOriginalInstitutionalPage(latestInstitutionalPageEntity);
            originalInstitutionalPageEntity.setWorkspaceFolderId(newFolderId);
            savedInstitutionalPageEntity = this.institutionalPageHelper.save(userId, originalInstitutionalPageEntity);
        }
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPageEntity);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputInstitutionalPageDto> findAllPublishedInstitutionalPages(@NonNull Set<String> associationsToLoad, @NonNull Pageable pageable) {
        Page institutionalPageEntityPage = this.institutionalPageHelper.retrieveAllPublished(pageable);
        return this.dtoBuilder.mapEntitiesToDtos(null, institutionalPageEntityPage, associationsToLoad);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputInstitutionalPageDto> searchPublishedInstitutionalPages(@NonNull Set<String> associationsToLoad, @NonNull Pageable pageable, @NonNull InputSearchPublishedInstitutionalPageDto inputSearchPublishedInstitutionalPageDto) {
        SearchInstitutionalPageModel searchInstitutionalPageModel = this.dtoBuilder.toFilters(inputSearchPublishedInstitutionalPageDto);
        Page institutionalPageEntityPage = this.institutionalPageHelper.retrieveAllApprovedWithFilter(pageable, searchInstitutionalPageModel);
        return this.dtoBuilder.mapEntitiesToDtos(null, institutionalPageEntityPage, associationsToLoad);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputInstitutionalPageDto findPublishedInstitutionalPageById(@NonNull UUID institutionalPageId) {
        InstitutionalPageEntity institutionalPageEntity = this.institutionalPageHelper.retrievePublishedById(institutionalPageId);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(null, institutionalPageEntity);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputInstitutionalPageDto requestPublishInstitutionalPage(@NonNull UUID userId, @NonNull UUID institutionalPageId) {
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        InstitutionalPageEntity retrievedInstitutionalPageEntity = this.institutionalPageHelper.retrieveLatestForMemberById(userId, institutionalPageId);
        InstitutionalPageEntity institutionalPageEntity = this.institutionalPageModerationHandler.update(userId, institutionalPageId, retrievedInstitutionalPageEntity);
        institutionalPageEntity.setPublished(true);
        InstitutionalPageEntity savedInstitutionalPageEntity = this.institutionalPageHelper.save(userId, institutionalPageEntity);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPageEntity);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputInstitutionalPageDto> findAllLatestVersionPendingInstitutionalPages(@NonNull UUID userId, @NonNull Set<String> associationsToLoad, @NonNull Pageable pageable) {
        Page institutionalPageEntityPage = this.memberHelper.hasIPModerateRole() ? this.institutionalPageHelper.retrieveAllPending(pageable) : this.institutionalPageHelper.retrieveAllPendingForMember(userId, pageable);
        return this.dtoBuilder.mapEntitiesToDtos(userId, institutionalPageEntityPage, associationsToLoad);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public Page<OutputInstitutionalPageDto> searchLatestVersionPendingInstitutionalPages(@NonNull UUID userId, @NonNull Set<String> associationsToLoad, @NonNull Pageable pageable, @NonNull InputSearchPendingInstitutionalPageDto inputSearchPendingInstitutionalPageDto) {
        Page institutionalPageEntityPage;
        if (this.memberHelper.hasIPModerateRole()) {
            SearchInstitutionalPageModel searchInstitutionalPageModel = this.dtoBuilder.toFilters(inputSearchPendingInstitutionalPageDto);
            institutionalPageEntityPage = this.institutionalPageHelper.retrieveAllPendingWithFilter(pageable, searchInstitutionalPageModel, inputSearchPendingInstitutionalPageDto.getModerationStatus());
        } else {
            SearchForMemberInstitutionalPageModel searchForMemberInstitutionalPageModel = this.dtoBuilder.toFiltersForMember(inputSearchPendingInstitutionalPageDto);
            institutionalPageEntityPage = this.institutionalPageHelper.retrieveAllPendingForMemberWithFilter(userId, pageable, searchForMemberInstitutionalPageModel, inputSearchPendingInstitutionalPageDto.getModerationStatus());
        }
        return this.dtoBuilder.mapEntitiesToDtos(userId, institutionalPageEntityPage, associationsToLoad);
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, readOnly=true, noRollbackFor={Exception.class})
    public OutputInstitutionalPageDto findLatestVersionPendingInstitutionalPageById(@NonNull UUID userId, @NonNull UUID institutionalPageId) {
        InstitutionalPageEntity institutionalPageEntity = this.memberHelper.hasIPModerateRole() ? this.institutionalPageHelper.retrievePendingById(institutionalPageId) : this.institutionalPageHelper.retrievePendingForMemberById(userId, institutionalPageId);
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, institutionalPageEntity);
        return outputInstitutionalPageDto;
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputModerationDto acceptOrRejectPendingInstitutionalPage(@NonNull UUID userId, @NonNull UUID institutionalPageId, @NonNull InputPatchIPModerationRequestDto inputPatchIPModerationRequestDto) {
        InstitutionalPageEntity savedInstitutionalPageEntity;
        this.memberHelper.verifyIPModeratorOrThrow();
        InstitutionalPageEntity institutionalPageEntity = this.institutionalPageHelper.retrieveLatestById(institutionalPageId);
        ModerationOperationType operationType = DefaultInstitutionalPageService.getModerationOperationType((InstitutionalPageEntity)institutionalPageEntity);
        if (inputPatchIPModerationRequestDto.getApproved().booleanValue()) {
            if ((institutionalPageEntity = this.institutionalPageModerationHandler.approve(institutionalPageId, institutionalPageEntity)).isToDelete()) {
                this.archiveHelper.persistArchivedCopy(institutionalPageEntity);
                this.institutionalPageHelper.delete(institutionalPageEntity);
                savedInstitutionalPageEntity = institutionalPageEntity;
            } else {
                savedInstitutionalPageEntity = this.institutionalPageHelper.save(userId, institutionalPageEntity);
            }
        } else {
            institutionalPageEntity = this.institutionalPageModerationHandler.reject(institutionalPageId, institutionalPageEntity, inputPatchIPModerationRequestDto.getMessage());
            savedInstitutionalPageEntity = this.institutionalPageHelper.save(userId, institutionalPageEntity);
        }
        OutputInstitutionalPageDto outputInstitutionalPageDto = this.dtoBuilder.mapEntityToDto(userId, savedInstitutionalPageEntity);
        return OutputModerationDto.builder().operationType(operationType.getLabel()).institutionalPage(outputInstitutionalPageDto).build();
    }

    @NonNull
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public OutputRequestUpdateDto requestUpdateInstitutionalPageById(@NonNull UUID userId, @NonNull UUID institutionalPageId) {
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        InstitutionalPageEntity institutionalPageEntity = this.institutionalPageHelper.retrieveLatestForMemberById(userId, institutionalPageId);
        if (institutionalPageEntity.getModerationStatus().equals((Object)ModerationStatus.PENDING)) {
            throw new InvalidModerationStatusException(institutionalPageId, institutionalPageEntity.getModerationStatus());
        }
        if (institutionalPageEntity.getUpdateLockedBy() == null) {
            institutionalPageEntity.setUpdateLockedBy(userId);
            institutionalPageEntity = this.institutionalPageHelper.save(userId, institutionalPageEntity);
        }
        boolean updateLockObtained = institutionalPageEntity.getUpdateLockedBy().equals(userId);
        return OutputRequestUpdateDto.builder().updateLockObtained(Boolean.valueOf(updateLockObtained)).updateLockedBy(institutionalPageEntity.getUpdateLockedBy()).build();
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void cancelUpdateInstitutionalPageById(@NonNull UUID userId, @NonNull UUID institutionalPageId) {
        this.memberHelper.verifyWpLeaderOrThrow(userId, institutionalPageId);
        InstitutionalPageEntity institutionalPageEntity = this.institutionalPageHelper.retrieveLatestForMemberById(userId, institutionalPageId);
        if (!userId.equals(institutionalPageEntity.getUpdateLockedBy())) {
            throw new UpdateLockedException(institutionalPageId, institutionalPageEntity.getUpdateLockedBy());
        }
        institutionalPageEntity.setUpdateLockedBy(null);
        this.institutionalPageHelper.save(userId, institutionalPageEntity);
    }

    private static ModerationOperationType getModerationOperationType(InstitutionalPageEntity institutionalPageEntity) {
        ModerationOperationType operationType = institutionalPageEntity.isToDelete() ? ModerationOperationType.DELETE : (institutionalPageEntity.getOriginalInstitutionalPageId() == null ? ModerationOperationType.CREATE : ModerationOperationType.UPDATE);
        return operationType;
    }

    @Generated
    public DefaultInstitutionalPageService(InstitutionalPageModerationHandler institutionalPageModerationHandler, InstitutionalPageHelper institutionalPageHelper, MemberHelper memberHelper, ArchiveHelper archiveHelper, EntityBuilder entityBuilder, DtoBuilder dtoBuilder) {
        this.institutionalPageModerationHandler = institutionalPageModerationHandler;
        this.institutionalPageHelper = institutionalPageHelper;
        this.memberHelper = memberHelper;
        this.archiveHelper = archiveHelper;
        this.entityBuilder = entityBuilder;
        this.dtoBuilder = dtoBuilder;
    }
}

