package com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum ModerationStatus {
    APPROVED("Approved"),
    PENDING("Pending"),
    REJECTED("Rejected"),
    DRAFT("Draft");

    private final String label;

    ModerationStatus(String label) {
        this.label = label;
    }

    @JsonValue
    public String getLabel() {
        return label;
    }

    /**
     * It maps the label to a {@link ModerationStatus} object
     *
     * @param label the label to map to enum
     * @return {@link ModerationStatus} instance if found
     * @throws IllegalArgumentException if no matching instance found
     */
    public static ModerationStatus ofLabel(String label) {
        for (ModerationStatus moderationStatus : ModerationStatus.values()) {
            if (moderationStatus.label.equalsIgnoreCase(label)) {
                return moderationStatus;
            }
        }

        throw new IllegalArgumentException("Unsupported value: " + label);
    }
}
