package com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums;

import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;

@Getter
public enum ModerationOperationType {
    CREATE("Create"),
    UPDATE("Update"),
    DELETE("Delete");

    private final String label;

    ModerationOperationType(String label) {
        this.label = label;
    }

    @JsonValue
    public String getLabel() {
        return label;
    }

    /**
     * It maps the label to a {@link ModerationOperationType} object
     *
     * @param label the label to map to enum
     * @return {@link ModerationOperationType} instance if found
     * @throws IllegalArgumentException if no matching instance found
     */
    public static ModerationOperationType ofLabel(String label) {
        for (ModerationOperationType moderationOperationType : ModerationOperationType.values()) {
            if (moderationOperationType.label.equalsIgnoreCase(label)) {
                return moderationOperationType;
            }
        }

        throw new IllegalArgumentException("Unsupported value: " + label);
    }
}
