/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.institutionalpage.dm.api;

import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputCreateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputSearchForMemberInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.InputUpdateInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputInstitutionalPageDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.dto.OutputRequestUpdateDto;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.enums.InstitutionalPageView;
import com.finconsgroup.itserr.marketplace.institutionalpage.dm.validation.ValidAssociationToLoad;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="InstitutionalPage", description="The InstitutionalPage API: it provides endpoints for creating, retrieving, searching, updating and deleting InstitutionalPages.")
@SecurityRequirement(name="BearerAuth")
public interface InstitutionalPageApi {
    @Operation(summary="Creates a new InstitutionalPage", responses={@ApiResponse(responseCode="201", description="Created")})
    @PostMapping(value={"/institutional-page/institutional-pages"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public OutputInstitutionalPageDto createInstitutionalPage(@Valid @RequestBody InputCreateInstitutionalPageDto var1);

    @Operation(summary="Retrieves a paginated list of all InstitutionalPages the user is contributing to", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/institutional-page/institutional-pages"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputInstitutionalPageDto> findAllInstitutionalPages(@RequestParam(name="view", required=false, defaultValue="LATEST") InstitutionalPageView var1, @RequestParam(name="includePublishedAndNotMember", defaultValue="false", required=false) boolean var2, @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var3, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var4, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var5, @RequestParam(name="sort", defaultValue="name", required=false) String var6, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var7);

    @Operation(summary="Retrieves a paginated list of all InstitutionalPages the user is contributing to, matching the search criteria", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(value={"/institutional-page/institutional-pages/search"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputInstitutionalPageDto> search(@RequestParam(name="view", required=false, defaultValue="LATEST") InstitutionalPageView var1, @Valid @RequestBody InputSearchForMemberInstitutionalPageDto var2, @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var3, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var4, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var5, @RequestParam(name="sort", defaultValue="name", required=false) String var6, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var7);

    @Operation(summary="Retrieves a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @GetMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto findInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1, @RequestParam(name="view", required=false, defaultValue="LATEST") InstitutionalPageView var2, @RequestParam(name="includePublishedAndNotMember", defaultValue="false", required=false) boolean var3);

    @Operation(summary="Updates a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto updateInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1, @Valid @RequestBody InputUpdateInstitutionalPageDto var2);

    @Operation(summary="Deletes a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @DeleteMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto deleteInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1);

    @Operation(summary="Retrieves a paginated list of all InstitutionalPages the user is contributing to, corresponding to the hierarchy associated to the rootInstitutionalPageId", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/hierarchy"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Page<OutputInstitutionalPageDto> findInstitutionalPagesHierarchyByRootId(@PathVariable(value="institutionalPageId") UUID var1, @RequestParam(name="associationsToLoad", defaultValue="all", required=false) Set<@ValidAssociationToLoad String> var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="name", required=false) String var5, @RequestParam(name="direction", defaultValue="ASC", required=false) Sort.Direction var6);

    @Operation(summary="Updates the folder ID associated with an institutional page, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/folders/{newFolderId}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto updateFolderId(@PathVariable(value="institutionalPageId") UUID var1, @PathVariable(value="newFolderId") UUID var2);

    @Operation(summary="Request moderation for a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/request-moderation"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto requestModerationInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1);

    @Operation(summary="Request publication for a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/request-publication"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputInstitutionalPageDto requestPublicationInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1);

    @Operation(summary="Request update for a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/request-update"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputRequestUpdateDto requestUpdateInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1);

    @Operation(summary="Release lock-for-update of a specific InstitutionalPage by id, only if the user is a member", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not Found")})
    @PutMapping(value={"/institutional-page/institutional-pages/{institutionalPageId}/cancel-update"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void cancelUpdateInstitutionalPageById(@PathVariable(value="institutionalPageId") UUID var1);
}

