/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metadata.bs.messaging.impl;

import com.finconsgroup.itserr.marketplace.metadata.bs.config.MetadataBsConfigurationProperties;
import com.finconsgroup.itserr.marketplace.metadata.bs.dto.OutputMetadataDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.mapper.MetadataMapper;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.ResourceProducer;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.dto.MessageBodyDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.dto.MetadataCreatedMessageBodyDto;
import com.finconsgroup.itserr.marketplace.metadata.bs.messaging.dto.MetadataDeletedMessageBodyDto;
import com.finconsgroup.itserr.messaging.exception.WP2MessagingException;
import com.finconsgroup.itserr.messaging.producer.MessageProducer;
import com.finconsgroup.itserr.messaging.producer.ProducerRegistry;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"messaging.enabled"}, havingValue="true")
public class DefaultResourceProducer
implements ResourceProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultResourceProducer.class);
    private final MetadataMapper metadataMapper;
    private final MessageProducer messageProducer;
    private final MetadataBsConfigurationProperties.Messaging messagingProperties;

    public DefaultResourceProducer(MetadataBsConfigurationProperties metadataBsConfigurationProperties, MetadataMapper metadataMapper, ProducerRegistry producerRegistry) {
        this.messagingProperties = metadataBsConfigurationProperties.getMessaging();
        this.metadataMapper = metadataMapper;
        this.messageProducer = producerRegistry.getMessageProducer(this.messagingProperties.getProducerName());
    }

    public void publishCreatedResource(@NonNull OutputMetadataDto metadata) {
        MetadataCreatedMessageBodyDto resource = this.metadataMapper.dtoToCreatedMessageDto(metadata);
        this.publish((MessageBodyDto)resource, this.messagingProperties.getResourceCreatedEventType());
    }

    public void publishDeletedResource(@NonNull UUID documentId) {
        MetadataDeletedMessageBodyDto resource = ((MetadataDeletedMessageBodyDto.MetadataDeletedMessageBodyDtoBuilder)MetadataDeletedMessageBodyDto.builder().id(documentId)).build();
        this.publish((MessageBodyDto)resource, this.messagingProperties.getResourceDeletedEventType());
    }

    private void publish(@NonNull MessageBodyDto resource, @NonNull String eventType) {
        try {
            Map<String, MessageBodyDto> messageMap = Map.of(String.valueOf(resource.getId()), resource);
            Map<String, String> filterProperties = Map.of("service", "metadata");
            log.debug("Sending message, messageMap: %s, eventType: %s, source: %s, filterProperties: %s".formatted(messageMap, eventType, this.messagingProperties.getSource(), filterProperties));
            this.messageProducer.publishEvent(messageMap, eventType, this.messagingProperties.getSource(), filterProperties);
            log.info("Successfully published message for resource with id: %s".formatted(resource.getId()));
        }
        catch (Exception e) {
            String errorMessage = "Error occurred while sending message: %s".formatted(e.getMessage());
            throw new WP2MessagingException(errorMessage);
        }
    }
}

