/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.metrics.bs.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.metrics.bs.client.MetricDmClient;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsComparisonDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsInfoAtDateDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsInfoAtTodayDateDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.OutputMetricsInterestsDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.dto.metrics.OutputUserInterestInfoDto;
import com.finconsgroup.itserr.marketplace.metrics.bs.repository.CatalogRepository;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricInterestService;
import com.finconsgroup.itserr.marketplace.metrics.bs.service.MetricService;
import java.time.LocalDate;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultMetricService
implements MetricService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricService.class);
    private final CatalogRepository catalogRepository;
    private final MetricDmClient metricDmClient;
    private final MetricInterestService metricInterestService;

    public OutputMetricsComparisonDto getUserMetrics(LocalDate comparisonDate) {
        UUID userId = JwtTokenHolder.getUserIdOrThrow();
        Set itemsIds = this.catalogRepository.getUserItemIds(userId);
        OutputMetricsDto metrics = new OutputMetricsDto();
        OutputMetricsDto cmqMetrics = new OutputMetricsDto();
        if (!itemsIds.isEmpty()) {
            metrics.putAll((Map)this.metricDmClient.findResourcesSummaryMetrics(itemsIds, null));
            if (comparisonDate != null) {
                cmqMetrics.putAll((Map)this.metricDmClient.findResourcesSummaryMetrics(itemsIds, comparisonDate));
            }
        }
        OutputMetricsInterestsDto todayMetricsInterests = this.metricInterestService.getUserMetricsInterests(metrics);
        OutputMetricsInterestsDto cmpMetricsInterests = this.metricInterestService.getUserMetricsInterests(cmqMetrics);
        double todayInterestScore = this.metricInterestService.getTotalInterest(todayMetricsInterests);
        double cmpInterestScore = this.metricInterestService.getTotalInterest(cmpMetricsInterests);
        OutputUserInterestInfoDto interestInfo = this.metricDmClient.getUserInterestInfo(userId);
        double interestWorseUsersRatio = (double)interestInfo.getWorseEventsBeneficiaries() / (double)interestInfo.getTotalEventsBeneficiaries();
        double roundedInterestWorseUsersRatio = (double)Math.round(interestWorseUsersRatio * 100.0) / 100.0;
        return OutputMetricsComparisonDto.builder().today(((OutputMetricsInfoAtTodayDateDto.OutputMetricsInfoAtTodayDateDtoBuilder)((OutputMetricsInfoAtTodayDateDto.OutputMetricsInfoAtTodayDateDtoBuilder)((OutputMetricsInfoAtTodayDateDto.OutputMetricsInfoAtTodayDateDtoBuilder)OutputMetricsInfoAtTodayDateDto.builder().metrics(metrics)).interest(Double.valueOf(todayInterestScore))).metricsInterest(todayMetricsInterests)).interestWorseUsersRatio(Double.valueOf(roundedInterestWorseUsersRatio)).build()).cmpDate(comparisonDate != null ? ((OutputMetricsInfoAtDateDto.OutputMetricsInfoAtDateDtoBuilder)((OutputMetricsInfoAtDateDto.OutputMetricsInfoAtDateDtoBuilder)((OutputMetricsInfoAtDateDto.OutputMetricsInfoAtDateDtoBuilder)OutputMetricsInfoAtDateDto.builder().date(comparisonDate).metrics(cmqMetrics)).interest(Double.valueOf(cmpInterestScore))).metricsInterest(cmpMetricsInterests)).build() : null).build();
    }

    @Generated
    public DefaultMetricService(CatalogRepository catalogRepository, MetricDmClient metricDmClient, MetricInterestService metricInterestService) {
        this.catalogRepository = catalogRepository;
        this.metricDmClient = metricDmClient;
        this.metricInterestService = metricInterestService;
    }
}

