package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;

import java.time.LocalDate;
import java.util.LinkedHashMap;

/**
 * Data Transfer Object (DTO) for representing metrics data aggregated daily for multiple resources. Each entry in the map corresponds to a specific date (key)
 * and its associated metrics data (value). An additional entry named "interest" is added, and contains the interest score delta due to the daily metrics.
 */
@Schema(example = """
        {"2025-10-24": {
          "111-222-333": {
            "interest": 21.5,
            "metrics": {
              "catalog-item-download":12.0,
              "catalog-item-view":44.0
            }
          }
        }}
        """)
public class OutputResourcesDailyMetricsDto extends LinkedHashMap<LocalDate, OutputResourcesMetricsDto> {
}
