package com.finconsgroup.itserr.marketplace.metrics.dm.mapper;

import com.finconsgroup.itserr.marketplace.metrics.dm.dto.InputCreateMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.MetricDtoType;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.dto.OutputMetricEventRefDto;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventBeneficiaryEntity;
import com.finconsgroup.itserr.marketplace.metrics.dm.entity.MetricEventEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

import java.util.Collection;

/**
 * Mapper interface responsible for converting between MetricEvent DTOs and entities.
 */
@Mapper(config = MapperConfiguration.class, uses = { MetricTypeMapper.class, BeneficiaryMapper.class })
public interface MetricEventMapper {

    /**
     * Converts an {@link InputCreateMetricEventDto} to a {@link MetricEventEntity}.
     *
     * @param metric the metric type to convert the event for
     * @param model the DTO to convert
     * @return the corresponding entity
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    MetricEventEntity toEntity(
            MetricDtoType metric,
            InputCreateMetricEventDto model);

    /**
     * Converts a {@link MetricEventEntity} to an {@link OutputMetricEventDto}.
     *
     * @param entity the entity to convert
     * @param beneficiaries the collection of beneficiaries associated with the metric event
     * @return the corresponding DTO
     */
    @Mapping(target = "beneficiaries", source = "beneficiaries", qualifiedByName = "beneficiariesToDtoList")
    OutputMetricEventDto toDto(
            MetricEventEntity entity,
            Collection<MetricEventBeneficiaryEntity> beneficiaries);

    /**
     * Converts a {@link MetricEventEntity} to an {@link OutputMetricEventRefDto}.
     *
     * @param entity the metric event entity to be converted
     * @return the corresponding reference DTO representation of the metric event
     */
    OutputMetricEventRefDto toRefDto(MetricEventEntity entity);

}
