package com.finconsgroup.itserr.marketplace.metrics.dm.bs;

import com.finconsgroup.itserr.marketplace.metrics.dm.config.MVUpdateConfiguration;
import lombok.RequiredArgsConstructor;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

import static com.finconsgroup.itserr.marketplace.metrics.dm.config.properties.MVUpdateConfigurationProperties.DEFAULT_INTERVAL;
import static com.finconsgroup.itserr.marketplace.metrics.dm.config.properties.MVUpdateConfigurationProperties.PROP_INTERVAL;

/**
 * Scheduler component that periodically triggers materialized view updates using configured intervals.
 */
@Component
@RequiredArgsConstructor
public class CronMVUpdater {

    /** Service responsible for performing materialized view updates */
    private final MVUpdater mvUpdater;

    /**
     * Scheduled method that triggers materialized view update at configured intervals.
     */
    @Scheduled(
            initialDelay = 0,
            fixedDelayString = "${" + PROP_INTERVAL + ":" + DEFAULT_INTERVAL + "}",
            timeUnit = TimeUnit.MINUTES,
            scheduler = MVUpdateConfiguration.MV_UPDATE_SCHEDULER)
    public void update() {
        mvUpdater.update();
    }

}
