package com.finconsgroup.itserr.marketplace.metrics.dm.config.properties;

import jakarta.validation.constraints.Min;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Configuration properties for managing materialized view updates.
 */
@Data
@ConfigurationProperties(prefix = "metrics.dm.materialized-view.update")
public class MVUpdateConfigurationProperties {

    /** Configuration property prefix for materialized view updates */
    public static final String PROP_PREFIX = "metrics.dm.materialized-view.update";
    /** Configuration property name for an update interval */
    public static final String PROP_INTERVAL = PROP_PREFIX + ".interval";

    /** Default interval value in minutes for materialized view updates */
    public static final int DEFAULT_INTERVAL = 60;
    /** Default cooldown period in minutes between materialized view updates */
    public static final int DEFAULT_COOLDOWN = 5;
    /** Default value indicating whether materialized view updates should occur whenever new events are added. */
    private static final boolean DEFAULT_UPDATE_ON_NEW_EVENTS = true;

    /**
     * Interval in minutes between two consecutive updates of the materialized views.
     */
    @Min(1)
    private int interval = DEFAULT_INTERVAL;

    /**
     * Specifies the cooldown period in minutes between updates to materialized views. It must be a non-negative integer.
     */
    @Min(0)
    private int cooldown = DEFAULT_COOLDOWN;

    /**
     * Determines whether updates to materialized views should occur immediately when new events are detected. Defaults to
     * {@value DEFAULT_UPDATE_ON_NEW_EVENTS}.
     */
    private boolean onNewEvents = DEFAULT_UPDATE_ON_NEW_EVENTS;

}
