package com.finconsgroup.itserr.marketplace.metrics.dm.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.ZonedDateTime;
import java.util.UUID;

/**
 * Output DTO representing a metricEvent reference.
 */
@Schema(name = "OutputMetricEventRef", description = "DTO representing a metricEvent reference")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputMetricEventRefDto {

    @Schema(description = "The id of the metricEvent", example = "f81d4fae-7dec-11d0-a765-00a0c91e6bf2")
    private UUID id;

    @Schema(description = "The metric", example = "catalog-item-download")
    private MetricDtoType metric;

    @Schema(description = "The id of the resource the event refers to", example = "123e4567-e89b-12d3-a456-426614174000")
    private String resourceId;

    @Schema(description = "The author of the event", example = "admin")
    private String eventAuthor;

    @Schema(description = "The time of the event", example = "2025-04-06T10:15:30+01:00")
    private ZonedDateTime eventTime;

    @Schema(description = "The creation time of the table record", example = "2025-04-06T10:15:30+01:00")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ssXXX")
    private ZonedDateTime creationTime;

}
