package com.finconsgroup.itserr.marketplace.metrics.dm.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * Entity class representing the interest weight of a metric.
 */
@Entity
@Table(name = "metric_interest_weight")
@Data
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class MetricInterestWeightEntity {

    /**
     * The name of the metric.
     */
    @Id
    @Enumerated(EnumType.STRING)
    @Column(name = "metric", nullable = false)
    private MetricType metric;

    /**
     * The weight of the metric.
     */
    @Column(name = "weight", nullable = false)
    private double weight;

}
